/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aop.Dispatcher;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.remoting.InvokerLocator;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="ManagementView", componentType=@ManagementComponent(type="MCBean", subtype="*"))
public class ManagementViewImpl
implements ManagementView {
    private static Logger log = Logger.getLogger(ManagementViewImpl.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.management.messages";
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private ProfileService ps;
    private Profile activeProfile;
    private long activeProfileLastModified;
    private MainDeployer mainDeployer;
    private InvokerLocator locator;
    private HashMap<String, DeploymentTemplate> templates = new HashMap();
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private HashMap<ComponentType, Set<ManagedComponent>> compByCompType = new HashMap();
    private Map<String, ManagedObject> moRegistry = new HashMap<String, ManagedObject>();
    private Map<String, ManagedDeployment> managedDeployments = new HashMap<String, ManagedDeployment>();
    private Map<String, ManagedDeployment> bootstrapManagedDeployments = Collections.emptyMap();
    private Map<String, Set<ManagedProperty>> unresolvedRefs = new HashMap<String, Set<ManagedProperty>>();
    private Map<String, ManagedObject> runtimeMOs = new HashMap<String, ManagedObject>();
    private RuntimeComponentDispatcher dispatcher;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public ManagementViewImpl() {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public void loadProfile(ProfileKey key) throws Exception {
        if (this.activeProfile != null && this.activeProfile.getKey().equals((Object)key) && this.activeProfile.getLastModified() <= this.activeProfileLastModified) {
            log.debug((Object)("Not reloading profile: " + key + ", " + this.activeProfileLastModified));
            return;
        }
        this.activeProfile = this.ps.getProfile(key);
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchProfileException"));
            Object[] args = new Object[]{key};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        this.compByCompType.clear();
        this.managedDeployments.clear();
        this.moRegistry.clear();
        this.runtimeMOs.clear();
        this.unresolvedRefs.clear();
        boolean trace = log.isTraceEnabled();
        Collection deployments = this.activeProfile.getDeployments();
        for (VFSDeployment deployment : deployments) {
            try {
                ManagedDeployment md = this.getManagedDeployment((Deployment)deployment);
                this.processManagedDeployment(md, 0, trace);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to create ManagedDeployment for: " + deployment.getName()), (Throwable)e);
            }
        }
        for (ManagedDeployment md : this.bootstrapManagedDeployments.values()) {
            try {
                this.processManagedDeployment(md, 0, trace);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to process ManagedDeployment for: " + md.getName()), (Throwable)e);
            }
        }
        if (this.runtimeMOs.size() > 0) {
            log.warn((Object)("Failed to merged the following runtime ManagedObjects: " + this.runtimeMOs));
        }
        this.activeProfileLastModified = this.activeProfile.getLastModified();
    }

    public void reloadProfile() throws Exception {
        this.activeProfileLastModified = 0L;
        this.loadProfile(this.activeProfile.getKey());
    }

    protected void processManagedDeployment(ManagedDeployment md, int level, boolean trace) throws Exception {
        String name = md.getName();
        if (trace) {
            log.trace((Object)(name + " ManagedDeployment_" + level + ": " + md));
        }
        Map mos = md.getManagedObjects();
        if (trace) {
            log.trace((Object)(name + " ManagedObjects_ " + level + ": " + mos));
        }
        for (ManagedObject mo : mos.values()) {
            this.processManagedObject(mo, md);
        }
        this.managedDeployments.put(name, md);
        List mdChildren = md.getChildren();
        if (mdChildren != null && !mdChildren.isEmpty()) {
            for (ManagedDeployment mdChild : mdChildren) {
                this.processManagedDeployment(mdChild, level + 1, trace);
            }
        }
    }

    protected void processManagedObject(ManagedObject mo, ManagedDeployment md) throws Exception {
        Set<ManagedComponent> typeComps;
        String key = mo.getName() + "/" + mo.getNameType();
        if (mo.getName().equals("org.jboss.security.plugins.SecurityConfig")) {
            log.info((Object)"Saw SecurityConfig MO");
        }
        log.debug((Object)("ID for ManagedObject: " + key + ", attachmentName: " + mo.getAttachmentName()));
        Map moAnns = mo.getAnnotations();
        ManagementObject managementObject = (ManagementObject)moAnns.get(ManagementObject.class.getName());
        if (managementObject.isRuntime()) {
            ManagedObject parentMO = this.moRegistry.get(key);
            if (parentMO == null) {
                log.debug((Object)("Deferring resolution of runtime ManagedObject: " + managementObject));
                this.runtimeMOs.put(key, mo);
            } else {
                this.mergeRuntimeMO(parentMO, mo);
                this.runtimeMOs.remove(key);
            }
            return;
        }
        ManagedObject runtimeMO = this.runtimeMOs.get(key);
        if (runtimeMO != null) {
            this.mergeRuntimeMO(mo, runtimeMO);
            this.runtimeMOs.remove(key);
        }
        this.checkForReferences(key, mo);
        for (ManagedComponent comp : md.getComponents().values()) {
            log.debug((Object)("Processing ManagementComponent: " + comp));
            ComponentType type = comp.getType();
            typeComps = this.compByCompType.get(type);
            if (typeComps == null) {
                typeComps = new HashSet<ManagedComponent>();
                this.compByCompType.put(type, typeComps);
            }
            typeComps.add(comp);
        }
        ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
        if (mc != null) {
            ComponentType type = new ComponentType(mc.type(), mc.subtype());
            ManagedComponentImpl comp = new ManagedComponentImpl(type, md, mo);
            md.addComponent(mo.getName(), (ManagedComponent)comp);
            log.debug((Object)("Processing ManagementComponent: " + comp));
            typeComps = this.compByCompType.get(type);
            if (typeComps == null) {
                typeComps = new HashSet<ManagedComponent>();
                this.compByCompType.put(type, typeComps);
            }
            typeComps.add((ManagedComponent)comp);
        }
        for (ManagedProperty prop : mo.getProperties().values()) {
            ArrayValue avalue;
            MetaType etype;
            ArrayMetaType amt;
            MetaType propType;
            log.debug((Object)("Checking property: " + prop));
            Map pannotations = prop.getAnnotations();
            if (pannotations != null && !pannotations.isEmpty()) {
                ManagementObjectRef ref;
                ManagementObjectID id = (ManagementObjectID)pannotations.get(ManagementObjectID.class.getName());
                if (id != null) {
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = id.name();
                    }
                    String propKey = refName + "/" + id.type();
                    log.debug((Object)("ManagedProperty level ID for ManagedObject: " + propKey + ", attachmentName: " + mo.getAttachmentName()));
                    this.moRegistry.put(propKey, mo);
                    this.checkForReferences(propKey, mo);
                }
                if ((ref = (ManagementObjectRef)pannotations.get(ManagementObjectRef.class.getName())) != null) {
                    String targetKey;
                    ManagedObject target;
                    log.debug((Object)("Property(" + prop.getName() + ") references: " + ref));
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = ref.name();
                    }
                    if ((target = this.moRegistry.get(targetKey = refName + "/" + ref.type())) != null) {
                        log.debug((Object)("Resolved property(" + prop.getName() + ") reference to: " + targetKey));
                        prop.setTargetManagedObject(target);
                    } else {
                        Set<ManagedProperty> referers = this.unresolvedRefs.get(targetKey);
                        if (referers == null) {
                            referers = new HashSet<ManagedProperty>();
                            this.unresolvedRefs.put(targetKey, referers);
                        }
                        referers.add(prop);
                    }
                }
            }
            if ((propType = prop.getMetaType()) == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                this.processGenericValue((GenericValue)prop.getValue(), md);
                continue;
            }
            if (propType.isArray()) {
                amt = (ArrayMetaType)propType;
                etype = amt.getElementType();
                if (etype != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) continue;
                avalue = (ArrayValue)prop.getValue();
                int length = avalue != null ? avalue.getLength() : 0;
                for (int n = 0; n < length; ++n) {
                    this.processGenericValue((GenericValue)avalue.getValue(n), md);
                }
                continue;
            }
            if (!propType.isCollection() || (etype = (amt = (CollectionMetaType)propType).getElementType()) != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE || (avalue = (CollectionValue)prop.getValue()) == null) continue;
            MetaValue[] elements = avalue.getElements();
            for (int n = 0; n < avalue.getSize(); ++n) {
                GenericValue gv = (GenericValue)elements[n];
                ManagedObject propMO = (ManagedObject)gv.getValue();
                if (propMO == null) continue;
                this.processManagedObject(propMO, md);
            }
        }
    }

    protected Object getRefName(Object value) {
        if (value instanceof MetaValue) {
            MetaValue metaValue = (MetaValue)value;
            if (!metaValue.getMetaType().isSimple()) {
                throw new IllegalArgumentException("Can only get ref from simple value: " + value);
            }
            SimpleValue svalue = (SimpleValue)metaValue;
            return svalue.getValue();
        }
        return value;
    }

    protected void processGenericValue(GenericValue genericValue, ManagedDeployment md) throws Exception {
        ManagedObject propMO;
        if (genericValue != null && (propMO = (ManagedObject)genericValue.getValue()) != null) {
            this.processManagedObject(propMO, md);
        }
    }

    public Map<String, ManagedDeployment> getBootstrapManagedDeployments() {
        return this.bootstrapManagedDeployments;
    }

    public void setBootstrapManagedDeployments(Map<String, ManagedDeployment> bootstrapManagedDeployments) {
        this.bootstrapManagedDeployments = bootstrapManagedDeployments;
    }

    public Map<String, Set<ManagedProperty>> getUnresolvedRefs() {
        return this.unresolvedRefs;
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
        log.debug((Object)("setProfileService: " + ps));
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
        log.debug((Object)("setMainDeployer: " + mainDeployer));
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    public void setMetaValueFactory(MetaValueFactory metaValueFactory) {
        this.metaValueFactory = metaValueFactory;
    }

    public void setDispatcher(RuntimeComponentDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Set<String> getDeploymentNames() {
        HashSet<String> names = new HashSet<String>();
        Set profileNames = this.activeProfile.getDeploymentNames();
        if (profileNames != null) {
            names.addAll(profileNames);
        }
        if (this.bootstrapManagedDeployments != null) {
            names.addAll(this.bootstrapManagedDeployments.keySet());
        }
        return names;
    }

    public Set<String> getDeploymentNamesForType(String type) {
        Set types;
        String name;
        HashSet<String> matches = new HashSet<String>();
        for (ManagedDeployment md : this.managedDeployments.values()) {
            name = md.getName();
            types = md.getTypes();
            if (types == null || !types.contains(type)) continue;
            log.debug((Object)(name + " matches type: " + type + ", types:" + types));
            matches.add(name);
        }
        for (ManagedDeployment md : this.bootstrapManagedDeployments.values()) {
            name = md.getName();
            types = md.getTypes();
            if (types == null || !types.contains(type)) continue;
            log.debug((Object)(name + " matches type: " + type + ", types:" + types));
            matches.add(name);
        }
        return matches;
    }

    public Set<String> getMatchingDeploymentName(String regex) throws NoSuchDeploymentException {
        Set<String> names = this.getDeploymentNames();
        HashSet<String> matches = new HashSet<String>();
        Pattern p = Pattern.compile(regex);
        for (String name : names) {
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            matches.add(name);
        }
        if (matches.size() == 0) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{regex};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        return matches;
    }

    public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher) throws NoSuchDeploymentException, Exception {
        HashSet<ManagedDeployment> matches = new HashSet<ManagedDeployment>();
        return matches;
    }

    public Set<String> getTemplateNames() {
        return new HashSet<String>(this.templates.keySet());
    }

    public void addTemplate(DeploymentTemplate template) {
        this.templates.put(template.getInfo().getName(), template);
        log.debug((Object)("addTemplate: " + template));
    }

    public void removeTemplate(DeploymentTemplate template) {
        this.templates.remove(template.getInfo().getName());
        log.debug((Object)("removeTemplate: " + template));
    }

    public ManagedDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws NoSuchDeploymentException, Exception {
        NoSuchDeploymentException profileEX = null;
        ManagedDeployment md = null;
        try {
            VFSDeployment ctx = this.activeProfile.getDeployment(name, phase);
            md = this.managedDeployments.get(ctx.getName());
        }
        catch (NoSuchDeploymentException e) {
            profileEX = e;
        }
        if (md == null) {
            md = this.bootstrapManagedDeployments.get(name);
        }
        if (md == null) {
            if (profileEX == null) {
                profileEX = new NoSuchDeploymentException("Managed deployment: " + name + " not found.");
            }
            throw profileEX;
        }
        return md;
    }

    public Set<ManagedDeployment> getDeploymentsForType(String type) throws Exception {
        Set<String> names = this.getDeploymentNamesForType(type);
        HashSet<ManagedDeployment> mds = new HashSet<ManagedDeployment>();
        for (String name : names) {
            VFSDeployment ctx = this.activeProfile.getDeployment(name, null);
            ManagedDeployment md = this.getManagedDeployment((Deployment)ctx);
            mds.add(md);
        }
        return mds;
    }

    public Set<ManagedComponent> getComponentsForType(ComponentType type) throws Exception {
        Set<Object> comps = this.compByCompType.get(type);
        if (comps == null) {
            comps = Collections.emptySet();
        }
        return comps;
    }

    public ManagedComponent getComponent(String name, ComponentType type) throws Exception {
        Set<ManagedComponent> components = this.compByCompType.get(type);
        ManagedComponent comp = null;
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!mc.getName().equals(name)) continue;
                comp = mc;
                break;
            }
        }
        if (comp != null) {
            Map props = comp.getProperties();
            Set ops = comp.getOperations();
            log.debug((Object)("Component(ops.size=" + ops != null ? ops.size() : ("0,props.size=)" + props != null ? props.size() : 0)));
        }
        return comp;
    }

    public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type, NameMatcher<ManagedComponent> matcher) throws Exception {
        Set<ManagedComponent> components = this.compByCompType.get(type);
        HashSet<ManagedComponent> matched = new HashSet<ManagedComponent>();
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!matcher.matches((Object)mc, name)) continue;
                matched.add(mc);
            }
        }
        if (matched.size() > 0) {
            log.debug((Object)("getComponents matched: " + matched));
        }
        return matched;
    }

    public DeploymentTemplateInfo getTemplate(String name) throws NoSuchDeploymentException {
        DeploymentTemplate template = this.templates.get(name);
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        DeploymentTemplateInfo info = template.getInfo();
        log.debug((Object)("getTemplate, " + info));
        return info;
    }

    public void applyTemplate(ManagedDeployment.DeploymentPhase phase, String deploymentBaseName, DeploymentTemplateInfo info) throws Exception {
        ManagedObject rootMO;
        Object[] args;
        DeploymentTemplate template = this.templates.get(info.getName());
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args2 = new Object[]{info.getName()};
            String msg = this.formatter.format(args2);
            throw new IllegalStateException(msg);
        }
        VirtualFile root = this.activeProfile.getRootFile(phase);
        if (log.isTraceEnabled()) {
            log.trace((Object)("applyTemplate, profile=" + this.activeProfile + ", deploymentBaseName=" + deploymentBaseName + ", phase=" + phase + ", info=" + info));
        }
        VirtualFile vf = template.applyTemplate(root, deploymentBaseName, info);
        VFSDeployment ctx = this.deploymentFactory.createVFSDeployment(vf);
        this.activeProfile.addDeployment(ctx, phase);
        this.mainDeployer.addDeployment((Deployment)ctx);
        template.updateTemplateDeployment(ctx, info);
        this.mainDeployer.process();
        for (ManagedProperty prop : info.getProperties().values()) {
            ManagementObjectID id;
            Map pannotations;
            if (prop.getValue() == null || (pannotations = prop.getAnnotations()) == null || (id = (ManagementObjectID)pannotations.get(ManagementObjectID.class.getName())) == null) continue;
            Object refName = this.getRefName(prop.getValue());
            if (refName == null) {
                refName = id.name();
            }
            String name = "" + refName;
            log.debug((Object)("Updating template ManagedObject name to:" + name + " from property: " + prop));
            ManagedObject mo = prop.getManagedObject();
            if (mo instanceof MutableManagedObject) {
                MutableManagedObject mmo = (MutableManagedObject)mo;
                mmo.setName(name);
                continue;
            }
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplatePropertyMO"));
            args = new Object[]{prop.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        Map mos = this.mainDeployer.getManagedObjects(ctx.getName());
        log.debug((Object)("applyTemplate, profile=" + this.activeProfile + ", deploymentBaseName=" + deploymentBaseName + ", phase=" + phase + ", :" + mos));
        String propName = info.getRootManagedPropertyName();
        if (propName != null && (rootMO = (ManagedObject)mos.get(ctx.getName())) != null) {
            this.flattenRootObject(rootMO, propName, mos);
        }
        for (ManagedProperty prop : info.getProperties().values()) {
            String mappedName;
            if (prop.getValue() == null) continue;
            ManagedObject mo = prop.getManagedObject();
            if (mo == null) {
                throw new IllegalArgumentException("Null managed object: " + prop);
            }
            ManagedObject ctxMO = (ManagedObject)mos.get(mo.getName());
            if (ctxMO == null) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateKey"));
                Object[] args3 = new Object[]{mo.getName()};
                String msg = this.formatter.format(args3);
                throw new IllegalArgumentException(msg);
            }
            ManagedProperty ctxProp = ctxMO.getProperty(prop.getName());
            if (ctxProp == null && (mappedName = prop.getMappedName()) != null) {
                ctxProp = ctxMO.getProperty(mappedName);
            }
            if (ctxProp == null) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateProperty"));
                args = new Object[]{prop.getName()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue value = prop.getValue();
            if (!(value instanceof MetaValue)) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidPropertyValue"));
                Object[] args4 = new Object[]{prop.getName(), value.getClass()};
                String msg = this.formatter.format(args4);
                throw new IllegalArgumentException(msg);
            }
            MetaValue metaValue = value;
            ctxProp.setValue(metaValue);
            Object componentName = this.getComponentName(ctxProp);
            if (componentName == null) continue;
            this.dispatcher.set(componentName, ctxProp.getName(), metaValue);
        }
    }

    public void removeDeployment(String deploymentName, ManagedDeployment.DeploymentPhase phase) throws NoSuchProfileException, NoSuchDeploymentException, Exception {
        log.debug((Object)("removeDeployment, " + deploymentName + ", phase: " + phase));
        VFSDeployment ctx = this.activeProfile.removeDeployment(deploymentName, phase);
        if (ctx == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{deploymentName};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        if (!this.mainDeployer.removeDeployment(ctx.getName())) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.MainDeployerRemoveException"));
            Object[] args = new Object[]{deploymentName};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        ManagedDeployment md = this.managedDeployments.remove(deploymentName);
        if (md != null) {
            log.debug((Object)("removeDeployment, md: " + md));
            Map comps = md.getComponents();
            if (comps != null) {
                for (ManagedComponent mc : comps.values()) {
                    ComponentType type = mc.getType();
                    Set<ManagedComponent> compsForType = this.compByCompType.get(type);
                    if (compsForType == null) continue;
                    if (compsForType.remove(mc)) {
                        log.debug((Object)("Removed mc: " + mc));
                        continue;
                    }
                    log.debug((Object)(mc + " was not found in set: " + compsForType));
                }
            }
        }
    }

    public void process() throws Exception {
        this.mainDeployer.process();
        this.mainDeployer.checkComplete();
        this.activeProfileLastModified = 0L;
    }

    public void updateComponent(ManagedComponent comp) throws Exception {
        ManagedDeployment.DeploymentPhase phase;
        ManagedDeployment md = comp.getDeployment();
        while (md.getParent() != null) {
            md = md.getParent();
        }
        String name = md.getName();
        VFSDeployment compDeployment = this.activeProfile.getDeployment(name, phase = md.getDeploymentPhase());
        if (compDeployment == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        ManagedDeployment compMD = this.managedDeployments.get(md.getName());
        log.debug((Object)("updateComponent, profile=" + this.activeProfile + ", deploymentName=" + name + ", phase=" + phase + ", :" + compMD));
        ManagedComponent serverComp = null;
        if (comp.getDeployment().getParent() == null) {
            serverComp = compMD.getComponent(comp.getName());
        } else {
            for (ManagedDeployment child : compMD.getChildren()) {
                if (serverComp != null) break;
                serverComp = child.getComponent(comp.getName());
            }
        }
        if (serverComp == null) {
            log.debug((Object)("Name: " + comp.getName() + " does not map to existing ManagedComponet in ManagedDeployment: " + md.getName() + ", components: " + compMD.getComponents()));
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), md.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        for (ManagedProperty prop : comp.getProperties().values()) {
            String mappedName;
            if (prop.getValue() == null || !prop.hasViewUse(ViewUse.CONFIGURATION)) continue;
            ManagedProperty ctxProp = (ManagedProperty)serverComp.getProperties().get(prop.getName());
            if (ctxProp == null && (mappedName = prop.getMappedName()) != null) {
                ctxProp = (ManagedProperty)serverComp.getProperties().get(mappedName);
            }
            if (ctxProp == null) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateProperty"));
                Object[] args = new Object[]{prop.getName()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue value = prop.getValue();
            if (!(value instanceof MetaValue)) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidPropertyValue"));
                Object[] args = new Object[]{prop.getName(), value.getClass()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue metaValue = value;
            ctxProp.setValue(metaValue);
            Object componentName = this.getComponentName(ctxProp);
            if (componentName == null) continue;
            this.dispatcher.set(componentName, ctxProp.getName(), metaValue);
        }
        this.activeProfile.updateDeployment(compDeployment, phase, serverComp);
    }

    protected Object getComponentName(ManagedProperty property) {
        ManagedObject targetObject = property.getTargetManagedObject();
        if (targetObject != null) {
            return targetObject.getComponentName();
        }
        targetObject = property.getManagedObject();
        return targetObject != null ? targetObject.getComponentName() : null;
    }

    protected void checkForReferences(String key, ManagedObject mo) {
        Set<ManagedProperty> referers = this.unresolvedRefs.get(key);
        log.debug((Object)("checkForReferences, " + key + " has referers: " + referers));
        if (referers != null) {
            for (ManagedProperty prop : referers) {
                prop.setTargetManagedObject(mo);
            }
            this.unresolvedRefs.remove(key);
        }
    }

    protected void mergeRuntimeMO(ManagedObject mo, ManagedObject runtimeMO) throws Exception {
        Map runtimeProps = runtimeMO.getProperties();
        Set<ManagedOperation> runtimeOps = runtimeMO.getOperations();
        log.debug((Object)("Merging runtime: " + runtimeMO.getName()));
        Map moProps = mo.getProperties();
        Set moOps = mo.getOperations();
        HashMap props = new HashMap(moProps);
        HashSet<ManagedOperation> ops = new HashSet<ManagedOperation>(moOps);
        if (runtimeProps != null && runtimeProps.size() > 0) {
            Object componentName = runtimeMO.getComponentName();
            log.debug((Object)("Properties before:" + props));
            for (ManagedProperty prop : runtimeProps.values()) {
                ViewUse[] uses;
                Map pannotations = prop.getAnnotations();
                if (pannotations == null) continue;
                ManagementProperty mpa = (ManagementProperty)pannotations.get(ManagementProperty.class.getName());
                for (ViewUse use : uses = mpa.use()) {
                    if (use != ViewUse.STATISTIC) continue;
                    String propName = prop.getMappedName();
                    try {
                        MetaValue propValue = this.dispatcher.get(componentName, propName);
                        if (propValue == null) continue;
                        prop.setValue(propValue);
                    }
                    catch (Throwable t) {
                        log.debug((Object)("Failed to get stat value, " + componentName + ":" + propName));
                    }
                }
            }
            props.putAll(runtimeProps);
            log.debug((Object)("Properties after:" + props));
        }
        if (runtimeOps != null && runtimeOps.size() > 0) {
            log.debug((Object)("Ops before:" + ops));
            runtimeOps = this.createOperationProxies(runtimeMO, runtimeOps);
            ops.addAll(runtimeOps);
            log.debug((Object)("Ops after:" + ops));
        }
        MutableManagedObject moi = (MutableManagedObject)mo;
        moi.setProperties(props);
        moi.setOperations(ops);
    }

    protected Set<ManagedOperation> createOperationProxies(ManagedObject mo, Set<ManagedOperation> ops) throws Exception {
        if (this.dispatcher == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        ClassLoader loader = this.getClass().getClassLoader();
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(SecurityClientInterceptor.singleton);
        interceptors.add(MergeMetaDataInterceptor.singleton);
        interceptors.add(InvokeRemoteInterceptor.singleton);
        HashSet<ManagedOperation> opProxies = new HashSet<ManagedOperation>();
        Class[] ifaces = new Class[]{ManagedOperation.class};
        for (ManagedOperation op : ops) {
            String dispatchName = "ProfileService.ManagedOperation@" + System.identityHashCode(op);
            Dispatcher.singleton.registerTarget((Object)dispatchName, (Object)new ManagedOperationDelegate(op, mo));
            ManagedOperation opProxy = (ManagedOperation)Remoting.createRemoteProxy((Object)dispatchName, (ClassLoader)loader, (Class[])ifaces, (InvokerLocator)this.locator, interceptors, (String)"ProfileService");
            opProxies.add(opProxy);
        }
        return opProxies;
    }

    private ManagedDeployment getManagedDeployment(Deployment ctx) throws Exception {
        return this.mainDeployer.getManagedDeployment(ctx.getName());
    }

    private void flattenRootObject(ManagedObject rootMO, String rootProperty, Map<String, ManagedObject> managedObjects) {
        CollectionValue avalue;
        CollectionMetaType amt;
        MetaType etype;
        ManagedProperty deployments = rootMO.getProperty(rootProperty);
        MetaType propType = deployments.getMetaType();
        if (propType.isCollection() && (etype = (amt = (CollectionMetaType)propType).getElementType()) == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE && (avalue = (CollectionValue)deployments.getValue()) != null) {
            MetaValue[] elements = avalue.getElements();
            for (int n = 0; n < avalue.getSize(); ++n) {
                GenericValue gv = (GenericValue)elements[n];
                ManagedObject propMO = (ManagedObject)gv.getValue();
                if (propMO == null) continue;
                managedObjects.put(propMO.getName(), propMO);
            }
        }
    }

    public class ManagedOperationDelegate
    implements ManagedOperation {
        private ManagedOperation delegate;
        private ManagedObject managedObject;

        public ManagedOperationDelegate(ManagedOperation delegate, ManagedObject managedObject) {
            if (delegate == null) {
                throw new IllegalArgumentException("Null delegate.");
            }
            this.delegate = delegate;
            if (managedObject == null) {
                throw new IllegalArgumentException("Null managed object.");
            }
            this.managedObject = managedObject;
        }

        public MetaValue invoke(MetaValue ... metaValues) {
            Object value;
            Object componentName = this.managedObject.getComponentName();
            MetaValue result = null;
            if (componentName != null && (value = ManagementViewImpl.this.dispatcher.invoke(componentName, this.delegate.getName(), metaValues)) != null) {
                result = ManagementViewImpl.this.metaValueFactory.create(value);
            }
            return result;
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public ManagedOperation.Impact getImpact() {
            return this.delegate.getImpact();
        }

        public MetaType getReturnType() {
            return this.delegate.getReturnType();
        }

        public ManagedParameter[] getParameters() {
            return this.delegate.getParameters();
        }
    }
}

