/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.templates;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;

public class JmsDestinationTemplateInfo
extends BasicDeploymentTemplateInfo {
    private static final long serialVersionUID = 1L;
    private String destinationType = "queue";

    public JmsDestinationTemplateInfo(String name, String description, String destinationType) {
        super(name, description);
        this.destinationType = destinationType;
        super.setRootManagedPropertyName("services");
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void start() {
        ManagedObjectImpl mo;
        if ("queue".equals(this.destinationType)) {
            mo = new ManagedObjectImpl("org.jboss.jms.server.destination.QueueServiceMO");
        } else if ("topic".equals(this.destinationType)) {
            mo = new ManagedObjectImpl("org.jboss.jms.server.destination.TopicServiceMO");
        } else {
            throw new IllegalStateException("Unexpected destination type: " + this.destinationType);
        }
        this.addManagedProperty("name", "The destination name", true, false, (MetaType)SimpleMetaType.STRING, mo);
        this.addManagedProperty("JNDIName", "The destination's JNDI name", false, true, (MetaType)SimpleMetaType.STRING, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, boolean isID, MetaType metaType, ManagedObjectImpl mo) {
        this.addManagedProperty(fieldName, fieldDescr, mandatory, isID, metaType, null, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, boolean isID, MetaType metaType, MetaValue value, ManagedObjectImpl mo) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl();
        this.setFieldName(fieldName, (Fields)fields);
        fields.setDescription(fieldDescr);
        fields.setMandatory(mandatory);
        fields.setMetaType(metaType);
        ManagedPropertyImpl mp = new ManagedPropertyImpl((ManagedObject)mo, (Fields)fields);
        if (isID) {
            HashMap<String, ManagementObjectID> annotations = new HashMap<String, ManagementObjectID>();
            Map idFields = Collections.emptyMap();
            try {
                ManagementObjectID id = (ManagementObjectID)AnnotationProxy.createProxy(idFields, ManagementObjectID.class);
                annotations.put(ManagementObjectID.class.getName(), id);
                mp.setAnnotations(annotations);
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        super.addProperty((ManagedProperty)mp);
        if (value != null) {
            mp.setValue(value);
        }
    }

    protected void setFieldName(String name, Fields f) {
        f.setField("name", (Object)name);
    }
}

