/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.DeploymentTarget;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.upload.DeploymentProgressImpl;
import org.jboss.profileservice.management.upload.SerializableDeploymentID;
import org.jboss.profileservice.management.upload.remoting.DeployHandler;
import org.jboss.profileservice.management.upload.remoting.StreamingDeploymentTarget;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerImpl
implements DeploymentManager {
    private static Logger log = Logger.getLogger(DeploymentManagerImpl.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.management.upload.messages";
    private ProfileService ps;
    private Profile activeProfile;
    private DeploymentRepositoryFactory repositoryFactory;
    private DeployHandler deployHandler;
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private InvokerLocator locator;
    private String remotingSubsystem = "DeploymentManager";

    public DeploymentManagerImpl() {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public DeploymentRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(DeploymentRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public DeployHandler getDeployHandler() {
        return this.deployHandler;
    }

    public void setDeployHandler(DeployHandler deployHandler) {
        this.deployHandler = deployHandler;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public String getRemotingSubsystem() {
        return this.remotingSubsystem;
    }

    public void setRemotingSubsystem(String remotingSubsystem) {
        this.remotingSubsystem = remotingSubsystem;
    }

    public DeploymentProgress distribute(String name, ManagedDeployment.DeploymentPhase phase, URL contentURL) throws Exception {
        return this.distribute(name, phase, contentURL, true);
    }

    public DeploymentProgress distribute(String name, ManagedDeployment.DeploymentPhase phase, URL contentURL, boolean copyContent) throws Exception {
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoProfileLoadedException"));
            Object[] args = new Object[]{};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(name, phase, contentURL.toString());
        deployment.setContentURL(contentURL);
        deployment.setCopyContent(copyContent);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.DISTRIBUTE);
    }

    public String[] getRepositoryNames(String[] names, ManagedDeployment.DeploymentPhase phase) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        return targets.get(0).getRepositoryNames(names, phase);
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public void loadProfile(ProfileKey key, boolean allowHotDeployments) throws Exception {
        this.activeProfile = this.ps.getProfile(key);
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoSuchProfileException"));
            Object[] args = new Object[]{key};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        log.debug((Object)("Loading profile, key: " + key + ", allowHotDeployments: " + allowHotDeployments));
        this.activeProfile.enableModifiedDeploymentChecks(allowHotDeployments);
        DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
        log.debug((Object)("DeploymentRepository for profile: " + repository));
        this.deployHandler.setDeploymentRepository(repository);
    }

    public void releaseProfile(ProfileKey key, boolean allowHotDeployments) throws Exception {
        this.activeProfile = this.ps.getProfile(key);
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoSuchProfileException"));
            Object[] args = new Object[]{key};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        log.debug((Object)("Releasing profile, key: " + key));
        this.activeProfile.enableModifiedDeploymentChecks(allowHotDeployments);
        this.deployHandler.setDeploymentRepository(null);
    }

    public DeploymentProgress redeploy(String name, ManagedDeployment.DeploymentPhase phase, URL contentURL) throws Exception {
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoProfileLoadedException"));
            Object[] args = new Object[]{};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(name, phase, null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.REDEPLOY);
    }

    public DeploymentProgress prepare(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        return this.doProgress(DeploymentStatus.CommandType.PREPARE, phase, names);
    }

    public DeploymentProgress start(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        return this.doProgress(DeploymentStatus.CommandType.START, phase, names);
    }

    public DeploymentProgress stop(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        return this.doProgress(DeploymentStatus.CommandType.STOP, phase, names);
    }

    public DeploymentProgress undeploy(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        return this.doProgress(DeploymentStatus.CommandType.UNDEPLOY, phase, names);
    }

    protected DeploymentProgress doProgress(DeploymentStatus.CommandType type, ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoProfileLoadedException"));
            Object[] args = new Object[]{};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        if (names == null || names.length == 0) {
            log.warn((Object)"Null or empty names.");
        }
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, phase, null);
        return new DeploymentProgressImpl(targets, deployment, type);
    }

    protected List<DeploymentTarget> getDeploymentTargets() {
        String targetName = this.locator.getHost();
        ArrayList<DeploymentTarget> targets = new ArrayList<DeploymentTarget>();
        StreamingDeploymentTarget hostTarget = new StreamingDeploymentTarget(this.locator, targetName, this.remotingSubsystem);
        targets.add(hostTarget);
        return targets;
    }
}

