/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.util.HashMap;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.deployers.spi.management.DelegatingComponentDispatcher;
import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;

public class DelegatingComponentDispatcherImpl
implements DelegatingComponentDispatcher {
    private static final ContextStateMapper<RunState> runStateMapper;
    private RuntimeComponentDispatcher dispatcher;
    private ProxyRegistry registry;

    public DelegatingComponentDispatcherImpl(ProxyRegistry registry, RuntimeComponentDispatcher dispatcher) {
        this.registry = registry;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaValue get(Long propID, Object componentName, String propertyName) {
        ManagedProperty mp = this.registry.getManagedProperty(propID);
        AbstractRuntimeComponentDispatcher.setActiveProperty(mp);
        try {
            MetaValue metaValue = this.dispatcher.get(componentName, propertyName);
            return metaValue;
        }
        finally {
            AbstractRuntimeComponentDispatcher.setActiveProperty(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaValue invoke(Long opID, Object componentName, String methodName, MetaValue ... param) {
        ManagedOperation op = this.registry.getManagedOperation(opID);
        AbstractRuntimeComponentDispatcher.setActiveOperation(op);
        try {
            if (param == null) {
                param = new MetaValue[]{};
            }
            MetaValue result = null;
            if (componentName != null) {
                result = (MetaValue)this.dispatcher.invoke(componentName, methodName, param);
            }
            MetaValue metaValue = result;
            return metaValue;
        }
        finally {
            AbstractRuntimeComponentDispatcher.setActiveOperation(null);
        }
    }

    public RunState updateRunState(Object componentName) {
        RunState state = RunState.UNKNOWN;
        try {
            state = (RunState)this.dispatcher.mapControllerState(componentName, runStateMapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    static {
        HashMap<String, RunState> runStateMappings = new HashMap<String, RunState>();
        runStateMappings.put("**ERROR**", RunState.FAILED);
        runStateMappings.put("Not Installed", RunState.STOPPED);
        runStateMappings.put("PreInstall", RunState.STOPPED);
        runStateMappings.put("Described", RunState.STOPPED);
        runStateMappings.put("Instantiated", RunState.STOPPED);
        runStateMappings.put("Configured", RunState.STOPPED);
        runStateMappings.put("Create", RunState.STOPPED);
        runStateMappings.put("Start", RunState.STOPPED);
        runStateMappings.put("Installed", RunState.RUNNING);
        runStateMapper = new ContextStateMapper(runStateMappings, (Enum)RunState.STARTING, (Enum)RunState.STOPPED, (Enum)RunState.FAILED, (Enum)RunState.UNKNOWN);
    }

    public static interface ProxyRegistry {
        public ManagedProperty getManagedProperty(Long var1);

        public ManagedOperation getManagedOperation(Long var1);
    }
}

