/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.security.integration.SecurityDomainObjectFactory;

public class JNDIContextEstablishment {
    private Logger log = Logger.getLogger(JNDIContextEstablishment.class);
    protected String BASE_CTX = "java:/jaas";
    private String factoryName = SecurityDomainObjectFactory.class.getName();

    public JNDIContextEstablishment() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.trace((Object)"Error in initialization of JNDIContextEstablishment", (Throwable)e);
        }
    }

    public void setBaseContext(String ctx) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is null");
        }
        this.BASE_CTX = ctx;
        this.initialize();
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.trace((Object)"Error in initialization of JNDIContextEstablishment", (Throwable)e);
        }
    }

    private void initialize() throws Exception {
        InitialContext ctx = new InitialContext();
        StringRefAddr refAddr = new StringRefAddr("nns", "JSM");
        Reference ref = new Reference("javax.naming.Context", refAddr, this.factoryName, null);
        ctx.rebind(this.BASE_CTX, (Object)ref);
    }
}

