/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.EntitlementHolder;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.plugins.AuthorizationManagerServiceMBean;
import org.jboss.security.plugins.JBossAuthorizationManager;
import org.jboss.security.plugins.JaasSecurityManagerService;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationManagerService
extends ServiceMBeanSupport
implements AuthorizationManagerServiceMBean {
    private static Logger log = Logger.getLogger(AuthorizationManagerService.class);
    private static String authorizationMgrClassName = "org.jboss.security.plugins.JBossAuthorizationManager";
    private static Class<?> authorizationMgrClass = JBossAuthorizationManager.class;
    private static Hashtable<String, AuthorizationManager> authorizationManagersMap = new Hashtable();
    private static String callbackHandlerClassName = "org.jboss.security.auth.callback.SecurityAssociationHandler";
    private static Class<?> callbackHandlerClass = SecurityAssociationHandler.class;
    private RuntimeException rte = new RuntimeException("Call the method on the authorization manager");

    @Override
    public void setAuthorizationManagerClassName(String className) throws ClassNotFoundException, ClassCastException {
        authorizationMgrClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        authorizationMgrClass = loader.loadClass(authorizationMgrClassName);
        if (!AuthorizationManager.class.isAssignableFrom(authorizationMgrClass)) {
            throw new ClassCastException(authorizationMgrClass + " does not implement " + AuthorizationManager.class);
        }
    }

    public void setCallbackHandlerClassName(String className) throws ClassNotFoundException {
        callbackHandlerClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        callbackHandlerClass = loader.loadClass(callbackHandlerClassName);
    }

    @Override
    public String getAuthorizationManagerClassName() {
        return authorizationMgrClassName;
    }

    public boolean doesUserHaveRole(String roleName) {
        String str = "Use getAuthorizationManager method and then call doesUserHaveRole";
        throw new IllegalStateException(str);
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> roles) {
        String str = "Use getAuthorizationManager method and then call doesUserHaveRole";
        throw new IllegalStateException(str);
    }

    protected void startService() throws Exception {
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public Set<Principal> getUserRoles(Principal principal) {
        String str = "Use getAuthorizationManager method and then call getUserRoles";
        throw new IllegalStateException(str);
    }

    public Principal getPrincipal(Principal principal) {
        String str = "Use getAuthorizationManager method and then call getPrincipal";
        throw new IllegalStateException(str);
    }

    @Override
    public AuthorizationManager getAuthorizationManager(String securityDomain) {
        AuthorizationManager amanager = authorizationManagersMap.get(securityDomain);
        if (amanager == null) {
            amanager = AuthorizationManagerService.newAuthorizationManager(securityDomain);
            authorizationManagersMap.put(securityDomain, amanager);
            log.debug((Object)("Added " + securityDomain + ", " + amanager + " to map"));
            try {
                InitialContext ctx = new InitialContext();
                SecurityDomainContext sdc = (SecurityDomainContext)ctx.lookup("java:jaas/security/domainContext");
                sdc.setAuthorizationManager(amanager);
            }
            catch (NamingException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Error in naming", (Throwable)e);
                }
                log.error((Object)"Error in getAuthorizationManager", (Throwable)e);
            }
        }
        return amanager;
    }

    public int authorize(Resource resource) {
        String str = "Use getAuthorizationManager method and then call authorize";
        throw new IllegalStateException(str);
    }

    static AuthorizationManager newAuthorizationManager(String securityDomain) {
        AuthorizationManager securityMgr = null;
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Constructor<?> ctor = authorizationMgrClass.getConstructor(parameterTypes);
            CallbackHandler handler = (CallbackHandler)callbackHandlerClass.newInstance();
            Object[] args = new Object[]{securityDomain};
            securityMgr = (AuthorizationManager)ctor.newInstance(args);
            log.debug((Object)("Created AuthorizationManager=" + securityMgr));
            CachePolicy cachePolicy = JaasSecurityManagerService.lookupCachePolicy(securityDomain);
            log.debug((Object)("Found Cache Policy=" + cachePolicy));
            AuthorizationManagerService.setSecurityDomainCache(securityMgr, cachePolicy);
        }
        catch (Exception e2) {
            String msg = "Failed to create authz mgr('" + securityDomain + "'), authorizationMgrClass=" + authorizationMgrClass;
            log.error((Object)msg, (Throwable)e2);
        }
        return securityMgr;
    }

    private static void setSecurityDomainCache(AuthorizationManager securityMgr, CachePolicy cachePolicy) {
        block2: {
            try {
                Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
                Method m = authorizationMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
                Object[] setCachePolicyArgs = new Object[]{cachePolicy};
                m.invoke((Object)securityMgr, setCachePolicyArgs);
                log.debug((Object)("setCachePolicy, c=" + setCachePolicyArgs[0]));
            }
            catch (Exception e2) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)("optional setCachePolicy failed:" + e2.getLocalizedMessage()));
            }
        }
    }

    public Group getTargetRoles(Principal targetPrincipal, Map<String, Object> contextMap) {
        throw this.rte;
    }

    public String getSecurityDomain() {
        throw this.rte;
    }

    public EntitlementHolder<?> entitlements(Resource resource, Identity identity) throws AuthorizationException {
        throw this.rte;
    }

    public int authorize(Resource arg0, Subject arg1, RoleGroup arg2) throws AuthorizationException {
        throw this.rte;
    }

    public int authorize(Resource arg0, Subject arg1, Group arg2) throws AuthorizationException {
        throw this.rte;
    }

    public RoleGroup getSubjectRoles(Subject arg0, CallbackHandler arg1) {
        throw this.rte;
    }
}

