/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentUtil {
    public static Document createDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentUtil.getFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static Document getDocument(String docString) throws Exception {
        return DocumentUtil.getDocument(new StringReader(docString));
    }

    public static Document getDocument(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentUtil.getFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(reader));
    }

    public static Document getDocument(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentUtil.getFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SysOutErrorHandler());
        return builder.parse(file);
    }

    public static Document getDocument(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentUtil.getFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SysOutErrorHandler());
        return builder.parse(is);
    }

    public static String getDocumentAsString(Document signedDoc) throws Exception {
        DOMSource source = new DOMSource(signedDoc);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, streamResult);
        return sw.toString();
    }

    public static String getDOMElementAsString(Element element) throws Exception {
        DOMSource source = new DOMSource(element);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, streamResult);
        return sw.toString();
    }

    public static InputStream getNodeAsStream(Node node) throws Exception {
        DOMSource source = new DOMSource(node);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, streamResult);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        return bis;
    }

    private static DocumentBuilderFactory getFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory;
    }

    private static class SysOutErrorHandler
    implements ErrorHandler {
        private SysOutErrorHandler() {
        }

        public void warning(SAXParseException ex) throws SAXException {
            System.out.println("Warning: " + ex.getMessage());
        }

        public void error(SAXParseException ex) throws SAXException {
            System.out.println("Error: " + ex.getMessage());
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            System.out.println("Fatal error: " + ex.getMessage());
        }
    }
}

