/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.security.integration.password.Password;
import org.jboss.security.integration.password.PasswordMaskManagement;
import org.jboss.security.integration.password.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordLifecycleCallback {
    private static final Logger log = Logger.getLogger(PasswordLifecycleCallback.class);
    private PasswordMaskManagement passwordManagement = null;

    public void setPasswordManagement(PasswordMaskManagement passwordManagement) {
        this.passwordManagement = passwordManagement;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
        boolean trace = log.isTraceEnabled();
        Password passwordAnnotation = (Password)invocation.resolveClassAnnotation(Password.class);
        if (trace) {
            log.trace((Object)("Checking method: " + mi.getMethod() + ", bindingInfo: " + passwordAnnotation));
        }
        if ("setKernelControllerContext".equals(mi.getMethod().getName()) && passwordAnnotation != null) {
            String securityDomain = passwordAnnotation.securityDomain();
            char[] passwd = this.passwordManagement.getPassword(securityDomain);
            Object target = context.getTarget();
            this.setPassword(target, passwordAnnotation, passwd);
        } else if (passwordAnnotation != null) {
            log.trace((Object)"Ignoring unsetKernelControllerContext callback");
        } else if (trace) {
            log.trace((Object)"Ignoring null password info");
        }
        return null;
    }

    public void install(ControllerContext context) throws Exception {
        List<Password> passwordAnnotations = this.readPasswordAnnotation(context);
        for (Password passwordAnnotation : passwordAnnotations) {
            String securityDomain;
            char[] passwd;
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)("Binding into JNDI: " + context.getName() + ", passwordInfo: " + passwordAnnotation));
            }
            if ((passwd = this.passwordManagement.getPassword(securityDomain = passwordAnnotation.securityDomain())) == null) {
                log.trace((Object)("Password does not exist for security domain=" + securityDomain));
            }
            String methodName = passwordAnnotation.methodName();
            Object target = context.getTarget();
            if (trace) {
                log.trace((Object)("Trying to set password on " + target + " with method :" + methodName));
            }
            this.setPassword(target, passwordAnnotation, passwd);
        }
    }

    public void uninstall(ControllerContext context) throws Exception {
    }

    private List<Password> readPasswordAnnotation(ControllerContext context) throws Exception {
        ArrayList<Password> passwordAnnotations = new ArrayList<Password>();
        AbstractKernelControllerContext akcc = (AbstractKernelControllerContext)context;
        BeanMetaData bmd = akcc.getBeanMetaData();
        Set annotations = bmd.getAnnotations();
        for (AnnotationMetaData annotationMetaData : annotations) {
            Annotation annotation = annotationMetaData.getAnnotationInstance();
            if (annotation.annotationType() != Password.class) continue;
            passwordAnnotations.add((Password)annotation);
        }
        return passwordAnnotations;
    }

    private void setPassword(Object target, Password passwordAnnotation, char[] passwd) throws Exception {
        Class<?> clazz = target.getClass();
        String methodName = passwordAnnotation.methodName();
        if (methodName == null) {
            throw new IllegalStateException("methodName " + methodName + " not configured on " + "the Password annotation for target:" + clazz);
        }
        Method m = SecurityActions.getMethod(clazz, methodName);
        try {
            m.invoke(target, new Object[]{passwd});
        }
        catch (Exception e) {
            log.trace((Object)("Error setting password on " + clazz + ". Will try the string version."));
            m.invoke(target, new String(passwd));
        }
    }
}

