/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import org.jboss.logging.Logger;
import org.jboss.security.ssl.JBossSSLConfiguration;

abstract class KeyManagerFactoryImpl
extends KeyManagerFactorySpi {
    protected KeyManagerFactory delegate;
    protected String defaultAlgorithm;
    protected static Logger log = Logger.getLogger(KeyManagerFactoryImpl.class);
    protected JBossSSLConfiguration sslConfiguration = JBossSSLConfiguration.getInstance();

    public KeyManagerFactoryImpl() {
        this.defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    }

    protected KeyManager[] engineGetKeyManagers() {
        return this.sslConfiguration.getKeyManagers(this.delegate);
    }

    protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.sslConfiguration.initializeKeyManagerFactory(this.delegate);
    }

    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        this.delegate.init(spec);
    }

    public static class IbmX509
    extends KeyManagerFactoryImpl {
        public IbmX509() {
            try {
                this.delegate = KeyManagerFactory.getInstance(this.defaultAlgorithm, "IBMJSSE2");
            }
            catch (Exception e) {
                log.error((Object)"Could not initialize KeyManagerFactory", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    public static class SunX509
    extends KeyManagerFactoryImpl {
        public SunX509() {
            try {
                this.delegate = KeyManagerFactory.getInstance(this.defaultAlgorithm, "SunJSSE");
            }
            catch (Exception e) {
                log.error((Object)"Could not initialize KeyManagerFactory", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }
}

