/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCDeclaredQueryMetaData
implements JDBCQueryMetaData {
    private final Method method;
    private final String additionalColumns;
    private final String from;
    private final String where;
    private final String order;
    private final String other;
    private final boolean distinct;
    private final String ejbName;
    private final String fieldName;
    private final String alias;
    private final JDBCReadAheadMetaData readAhead;
    private final boolean resultTypeMappingLocal;
    private final Class compiler;
    private final boolean lazyResultSetLoading;

    public JDBCDeclaredQueryMetaData(JDBCDeclaredQueryMetaData defaults, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading) throws DeploymentException {
        this.method = defaults.getMethod();
        this.readAhead = readAhead;
        this.from = defaults.getFrom();
        this.where = defaults.getWhere();
        this.order = defaults.getOrder();
        this.other = defaults.getOther();
        this.resultTypeMappingLocal = defaults.isResultTypeMappingLocal();
        this.distinct = defaults.isSelectDistinct();
        this.ejbName = defaults.getEJBName();
        this.fieldName = defaults.getFieldName();
        this.alias = defaults.getAlias();
        this.additionalColumns = defaults.getAdditionalColumns();
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
    }

    public JDBCDeclaredQueryMetaData(boolean isResultTypeMappingLocal, Element queryElement, Method method, JDBCReadAheadMetaData readAhead, Class compiler, boolean lazyResultSetLoading) throws DeploymentException {
        this.compiler = compiler;
        this.lazyResultSetLoading = lazyResultSetLoading;
        this.method = method;
        this.readAhead = readAhead;
        this.from = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)queryElement, (String)"from"));
        this.where = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)queryElement, (String)"where"));
        this.order = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)queryElement, (String)"order"));
        this.other = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)queryElement, (String)"other"));
        this.resultTypeMappingLocal = isResultTypeMappingLocal;
        Element selectElement = MetaData.getOptionalChild((Element)queryElement, (String)"select");
        if (selectElement != null) {
            boolean bl = this.distinct = MetaData.getOptionalChild((Element)selectElement, (String)"distinct") != null;
            if (method.getName().startsWith("ejbSelect")) {
                this.ejbName = MetaData.getUniqueChildContent((Element)selectElement, (String)"ejb-name");
                this.fieldName = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)selectElement, (String)"field-name"));
            } else {
                if (MetaData.getOptionalChild((Element)selectElement, (String)"ejb-name") != null) {
                    throw new DeploymentException("The ejb-name element of declared-sql select is only allowed for ejbSelect queries.");
                }
                if (MetaData.getOptionalChild((Element)selectElement, (String)"field-name") != null) {
                    throw new DeploymentException("The field-name element of declared-sql select is only allowed for ejbSelect queries.");
                }
                this.ejbName = null;
                this.fieldName = null;
            }
            this.alias = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)selectElement, (String)"alias"));
            this.additionalColumns = JDBCDeclaredQueryMetaData.nullIfEmpty(MetaData.getOptionalChildContent((Element)selectElement, (String)"additional-columns"));
        } else {
            if (method.getName().startsWith("ejbSelect")) {
                throw new DeploymentException("The select element of declared-sql is required for ejbSelect queries.");
            }
            this.distinct = false;
            this.ejbName = null;
            this.fieldName = null;
            this.alias = null;
            this.additionalColumns = null;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isResultTypeMappingLocal() {
        return this.resultTypeMappingLocal;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.readAhead;
    }

    public Class getQLCompilerClass() {
        return this.compiler;
    }

    public String getFrom() {
        return this.from;
    }

    public String getWhere() {
        return this.where;
    }

    public String getOrder() {
        return this.order;
    }

    public String getOther() {
        return this.other;
    }

    public boolean isSelectDistinct() {
        return this.distinct;
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAdditionalColumns() {
        return this.additionalColumns;
    }

    public boolean isLazyResultSetLoading() {
        return this.lazyResultSetLoading;
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCDeclaredQueryMetaData) {
            return ((JDBCDeclaredQueryMetaData)o).method.equals(this.method);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return "[JDBCDeclaredQueryMetaData : method=" + this.method + "]";
    }

    private static String nullIfEmpty(String s) {
        if (s != null && s.trim().length() == 0) {
            s = null;
        }
        return s;
    }
}

