/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.bridge;

import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.bridge.SelectorBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;

public class EJBSelectBridge
implements SelectorBridge {
    private static final byte SINGLE = 0;
    private static final byte COLLECTION = 2;
    private final JDBCQueryMetaData metadata;
    private final QueryCommand command;
    private final byte returnType;
    private final Schema schema;
    private boolean syncBeforeSelect;
    private TransactionManager tm;

    public EJBSelectBridge(EntityContainer container, Schema schema, JDBCQueryMetaData metadata, QueryCommand command) {
        this.schema = schema;
        this.metadata = metadata;
        this.command = command;
        Class<?> type = metadata.getMethod().getReturnType();
        this.returnType = Collection.class.isAssignableFrom(type) ? (byte)2 : (byte)0;
        this.tm = container.getTransactionManager();
        this.syncBeforeSelect = !container.getBeanMetaData().getContainerConfiguration().getSyncOnCommitOnly();
    }

    public Object invoke(EntityEnterpriseContext instance, Method method, Object[] args) throws Exception {
        Transaction tx;
        Transaction transaction = tx = instance != null ? instance.getTransaction() : this.tm.getTransaction();
        if (this.syncBeforeSelect) {
            EntityContainer.synchronizeEntitiesWithinTransaction(tx);
        }
        return this.execute(args);
    }

    public String getSelectorName() {
        return this.metadata.getMethod().getName();
    }

    public Method getMethod() {
        return this.metadata.getMethod();
    }

    public Object execute(Object[] args) throws FinderException {
        Object result;
        JDBCStoreManager2 manager = this.command.getStoreManager();
        GenericEntityObjectFactory factory = this.metadata.isResultTypeMappingLocal() ? manager.getContainer().getLocalProxyFactory() : manager.getContainer().getProxyFactory();
        switch (this.returnType) {
            case 0: {
                result = this.command.fetchOne(this.schema, factory, args);
                if (result != null || !this.getMethod().getReturnType().isPrimitive()) break;
                throw new FinderException("Cannot return null as a value of primitive type " + this.getMethod().getReturnType().getName());
            }
            case 2: {
                result = this.command.fetchCollection(this.schema, factory, args);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected return type: " + this.returnType);
            }
        }
        return result;
    }
}

