/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.logging.Log4jServiceMBean;
import org.jboss.logging.Logger;
import org.jboss.logging.SysPropertyActions;
import org.jboss.logging.log4j.JDKLevel;
import org.jboss.logging.util.LoggerStream;
import org.jboss.logging.util.OnlyOnceErrorHandler;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Strings;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.ThrowableListener;
import org.jboss.util.stream.Streams;

public class Log4jService
extends ServiceMBeanSupport
implements Log4jServiceMBean {
    public static final String DEFAULT_URL = System.getProperty(Log4jService.class.getName() + ".configURL", "resource:log4j.xml");
    public static final boolean CATCH_SYSTEM_OUT = Log4jService.getBoolean(Log4jService.class.getName() + ".catchSystemOut", true);
    public static final boolean CATCH_SYSTEM_ERR = Log4jService.getBoolean(Log4jService.class.getName() + ".catchSystemErr", true);
    public static final String DEFAULT_JBOSS_SERVER_LOG_THRESHOLD = "DEBUG";
    private URL configURL;
    private int refreshPeriod;
    private ThrowableListenerLoggingAdapter throwableAdapter;
    private PrintStream out;
    private PrintStream err;
    private boolean catchSystemOut = CATCH_SYSTEM_OUT;
    private boolean catchSystemErr = CATCH_SYSTEM_ERR;
    private boolean log4jQuietMode = true;
    private String defaultJBossServerLogLevel = "DEBUG";
    private Timer timer;
    private URLWatchTimerTask timerTask;
    private boolean initialized;

    private static boolean getBoolean(String name, boolean defaultValue) {
        String value = System.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        return new Boolean(value);
    }

    public Log4jService() throws MalformedURLException {
        this(DEFAULT_URL, 60);
    }

    public Log4jService(URL url) {
        this(url, 60);
    }

    public Log4jService(String url) throws MalformedURLException {
        this(Strings.toURL((String)url), 60);
    }

    public Log4jService(String url, int refreshPeriod) throws MalformedURLException {
        this(Strings.toURL((String)url), refreshPeriod);
    }

    public Log4jService(URL url, int refreshPeriod) {
        this.configURL = url;
        this.refreshPeriod = refreshPeriod;
    }

    public void setCatchSystemOut(boolean flag) {
        this.catchSystemOut = flag;
    }

    public boolean getCatchSystemOut() {
        return this.catchSystemOut;
    }

    public void setCatchSystemErr(boolean flag) {
        this.catchSystemErr = flag;
    }

    public boolean getCatchSystemErr() {
        return this.catchSystemErr;
    }

    public boolean getLog4jQuietMode() {
        return this.log4jQuietMode;
    }

    public void setLog4jQuietMode(boolean flag) {
        this.log4jQuietMode = flag;
    }

    public int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(int refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    public URL getConfigurationURL() {
        return this.configURL;
    }

    public void setConfigurationURL(URL url) {
        this.configURL = url;
    }

    public String getDefaultJBossServerLogThreshold() {
        return this.defaultJBossServerLogLevel;
    }

    public void setDefaultJBossServerLogThreshold(String level) {
        this.defaultJBossServerLogLevel = level;
    }

    public void setLoggerLevel(String name, String levelName) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)name.trim());
        Level level = JDKLevel.toLevel((String)levelName.trim());
        logger.setLevel(level);
        this.log.info((Object)("Level set to " + level + " for " + name));
    }

    public void setLoggerLevels(String list, String levelName) {
        StringTokenizer stok = new StringTokenizer(list, ",");
        while (stok.hasMoreTokens()) {
            String name = stok.nextToken();
            this.setLoggerLevel(name, levelName);
        }
    }

    public String getLoggerLevel(String name) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)name);
        Level level = logger.getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public void reconfigure() throws IOException {
        if (this.timerTask == null) {
            throw new IllegalStateException("Service stopped or not started");
        }
        this.timerTask.reconfigure();
    }

    public void reconfigure(String url) throws IOException, MalformedURLException {
        this.setConfigurationURL(Strings.toURL((String)url));
        this.reconfigure();
    }

    private void installSystemAdapters() {
        org.apache.log4j.Logger logger;
        if (this.catchSystemOut) {
            logger = org.apache.log4j.Logger.getLogger((String)"STDOUT");
            this.out = System.out;
            System.setOut((PrintStream)new LoggerStream(logger, Level.INFO, this.out));
            this.log.debug((Object)"Installed System.out adapter");
        }
        if (this.catchSystemErr) {
            logger = org.apache.log4j.Logger.getLogger((String)"STDERR");
            this.err = System.err;
            OnlyOnceErrorHandler.setOutput((PrintStream)this.err);
            System.setErr((PrintStream)new LoggerStream(logger, Level.ERROR, this.err));
            this.log.debug((Object)"Installed System.err adapter");
        }
    }

    private void uninstallSystemAdapters() {
        if (this.out != null) {
            System.out.flush();
            System.setOut(this.out);
            this.log.debug((Object)"Removed System.out adapter");
            this.out = null;
        }
        if (this.err != null) {
            System.err.flush();
            System.setErr(this.err);
            this.log.debug((Object)"Removed System.err adapter");
            this.err = null;
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    private void setup() throws Exception {
        if (this.initialized) {
            return;
        }
        this.establishDefaultLoggingLevelSystemProperty();
        this.timerTask = new URLWatchTimerTask();
        this.timerTask.run();
        this.timer = new Timer("Timer-" + this.getName(), true);
        this.timer.schedule((TimerTask)this.timerTask, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
        org.apache.log4j.Logger.getRootLogger();
        this.throwableAdapter = new ThrowableListenerLoggingAdapter();
        ThrowableHandler.addThrowableListener((ThrowableListener)this.throwableAdapter);
        this.log.debug((Object)("Added ThrowableListener: " + this.throwableAdapter));
        this.initialized = true;
    }

    private void establishDefaultLoggingLevelSystemProperty() {
        try {
            if (this.defaultJBossServerLogLevel != null && SysPropertyActions.getProperty("jboss.server.log.threshold", null) == null) {
                SysPropertyActions.setProperty("jboss.server.log.threshold", this.defaultJBossServerLogLevel);
            }
        }
        catch (SecurityException e) {
            this.log.warn((Object)("Cannot configure system property jboss.server.log.threshold -- " + e.getLocalizedMessage()));
        }
    }

    protected void createService() throws Exception {
        this.setup();
    }

    protected void startService() throws Exception {
        this.setup();
    }

    protected void stopService() throws Exception {
        this.timer.cancel();
        this.timer = null;
        this.timerTask.cancel();
        this.timerTask = null;
        ThrowableHandler.removeThrowableListener((ThrowableListener)this.throwableAdapter);
        this.throwableAdapter = null;
        this.uninstallSystemAdapters();
        this.initialized = false;
    }

    protected void emitReconfigureNotification() {
        Notification n = new Notification("jboss.logging.log4j.reconfigure", (Object)this, this.getNextNotificationSequenceNumber(), "Log4j subsystem reconfigured");
        n.setUserData(this.configURL);
        super.sendNotification(n);
    }

    private class URLWatchTimerTask
    extends TimerTask {
        private Logger log = Logger.getLogger(URLWatchTimerTask.class);
        private long lastConfigured = -1L;

        private URLWatchTimerTask() {
        }

        public void run() {
            this.log.trace((Object)"Checking if configuration changed");
            boolean trace = this.log.isTraceEnabled();
            try {
                URLConnection conn = Log4jService.this.configURL.openConnection();
                if (trace) {
                    this.log.trace((Object)("connection: " + conn));
                }
                long lastModified = conn.getLastModified();
                if (trace) {
                    this.log.trace((Object)("last configured: " + this.lastConfigured));
                    this.log.trace((Object)("last modified: " + lastModified));
                }
                if (this.lastConfigured < lastModified) {
                    this.reconfigure(conn);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to check URL: " + Log4jService.this.configURL), (Throwable)e);
            }
        }

        public void reconfigure() throws IOException {
            URLConnection conn = Log4jService.this.configURL.openConnection();
            this.reconfigure(conn);
        }

        private void reconfigure(URLConnection conn) {
            this.log.debug((Object)("Configuring from URL: " + Log4jService.this.configURL));
            boolean xml = false;
            boolean trace = this.log.isTraceEnabled();
            String contentType = conn.getContentType();
            if (trace) {
                this.log.trace((Object)("content type: " + contentType));
            }
            if (contentType == null) {
                String filename = Log4jService.this.configURL.getFile().toLowerCase();
                if (trace) {
                    this.log.trace((Object)("filename: " + filename));
                }
                xml = filename.endsWith(".xml");
            } else {
                xml = contentType.equalsIgnoreCase("text/xml");
                xml |= contentType.equalsIgnoreCase("application/xml");
            }
            if (trace) {
                this.log.trace((Object)("reconfiguring; xml=" + xml));
            }
            if (trace) {
                try {
                    InputStream is = conn.getInputStream();
                    Streams.copy((InputStream)is, (OutputStream)System.out);
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to dump config", (Throwable)e);
                }
            }
            Log4jService.this.uninstallSystemAdapters();
            if (xml) {
                DOMConfigurator.configure((URL)Log4jService.this.configURL);
            } else {
                PropertyConfigurator.configure((URL)Log4jService.this.configURL);
            }
            LogLog.setQuietMode((boolean)Log4jService.this.log4jQuietMode);
            Log4jService.this.installSystemAdapters();
            this.lastConfigured = System.currentTimeMillis();
            Log4jService.this.emitReconfigureNotification();
        }
    }

    private static class ThrowableListenerLoggingAdapter
    implements ThrowableListener {
        private Logger log = Logger.getLogger(ThrowableListenerLoggingAdapter.class);

        private ThrowableListenerLoggingAdapter() {
        }

        public void onThrowable(int type, Throwable t) {
            switch (type) {
                default: {
                    this.log.error((Object)"Unhandled Throwable", t);
                    break;
                }
                case 2: {
                    this.log.warn((Object)"Unhandled Throwable", t);
                    break;
                }
                case 0: {
                    this.log.trace((Object)"Ynhandled Throwable; status is unknown", t);
                }
            }
        }
    }
}

