/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.Enumeration;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASBasedServer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingProviderURLWriter {
    public static final String DEFAULT_PERSIST_FILE_NAME = "jnp-service.url";
    private static final Logger log = Logger.getLogger(NamingProviderURLWriter.class);
    private String bootstrapUrl;
    private String bindAddress;
    private int port;
    private JBossASBasedServer<?, ?> server;
    private URI outputDir;
    private String filename = "jnp-service.url";

    public URI getOutputDirURI() {
        return this.outputDir;
    }

    public void setOutputDirURL(URI dir) {
        this.outputDir = dir;
    }

    public String getOutputFileName() {
        return this.filename == null ? DEFAULT_PERSIST_FILE_NAME : this.filename;
    }

    public void setOutputFileName(String name) {
        this.filename = name;
    }

    public void setServer(JBossASBasedServer<?, ?> server) {
        this.server = server;
    }

    public String getBootstrapURL() {
        return this.bootstrapUrl;
    }

    public void setBootstrapURL(String url) {
        this.bootstrapUrl = url;
    }

    public String getBootstrapAddress() {
        return this.bindAddress;
    }

    public void setBootstrapAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getBootstrapPort() {
        return this.port;
    }

    public void setBootstrapPort(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws Exception {
        this.establishBootStrapURL();
        if (this.bootstrapUrl != null) {
            File base = null;
            if (this.outputDir == null) {
                if (this.server != null) {
                    base = new File(((JBossASBasedServerConfig)this.server.getConfiguration()).getServerDataLocation().toURI());
                    this.outputDir = base.toURI();
                }
            } else {
                base = new File(this.outputDir);
            }
            if (base != null) {
                base.mkdirs();
                File file = new File(base, this.getOutputFileName());
                if (file.exists()) {
                    file.delete();
                }
                PrintWriter writer = null;
                try {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Creating file " + file));
                        }
                        file.createNewFile();
                        file.deleteOnExit();
                        writer = new PrintWriter(file);
                        writer.println(this.bootstrapUrl);
                        writer.flush();
                    }
                    catch (Exception e) {
                        this.handleOutputFileCreationException(file.toURI(), e);
                        Object var6_5 = null;
                        if (writer == null) return;
                        writer.close();
                        return;
                    }
                    Object var6_4 = null;
                    if (writer == null) return;
                    writer.close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
            } else {
                log.warn((Object)("No directory specified for " + this.getOutputFileName() + " cannot write the naming service url. Please configure either " + "the 'server' property or the 'outputDir' property."));
            }
            return;
        } else {
            log.debug((Object)"No URLs to write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleOutputFileCreationException(URI outputFile, Exception e) {
        block15: {
            handled = false;
            fr = null;
            try {
                block14: {
                    f = new File(outputFile);
                    if (!f.exists()) break block14;
                    fr = new FileReader(f);
                    existing = new BufferedReader(fr).readLine();
                    if (existing != null && this.bootstrapUrl.equals(existing.trim())) {
                        NamingProviderURLWriter.log.info((Object)("Experienced a problem (" + e + ") updating the naming service URL file " + outputFile + " but the current contents are correct."));
                    } else {
                        NamingProviderURLWriter.log.error((Object)("Cannot update naming service URL file " + outputFile), (Throwable)e);
                    }
                    handled = true;
                }
                var8_8 = null;
                ** if (fr == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                var8_10 = null;
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fr.close();
                }
                catch (Exception ignored) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception ignored) {
                    var8_9 = null;
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Exception ignored) {}
                    }
                }
            }
        }
        if (!handled) {
            NamingProviderURLWriter.log.error((Object)("Cannot create a naming service URL file at " + outputFile), (Throwable)e);
        }
    }

    public void stop() throws Exception {
        if (this.outputDir != null) {
            String outputFile = "";
            try {
                File f = new File(new File(this.outputDir), this.getOutputFileName());
                outputFile = f.getAbsolutePath();
                f.delete();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to delete JNP URL file " + outputFile + " due to " + e));
            }
        }
    }

    protected void establishBootStrapURL() throws IOException {
        if (this.getBootstrapURL() == null && this.getBootstrapAddress() != null) {
            InetAddress addr = InetAddress.getByName(this.getBootstrapAddress());
            if (addr.isAnyLocalAddress() && (addr = NamingProviderURLWriter.findLoopbackAddress()) == null) {
                addr = InetAddress.getLocalHost();
            }
            StringBuilder sb = new StringBuilder("jnp://");
            if (addr instanceof Inet6Address) {
                sb.append('[');
                sb.append(addr.getHostAddress());
                sb.append(']');
            } else {
                sb.append(addr.getHostAddress());
            }
            sb.append(':');
            sb.append(this.getBootstrapPort());
            this.setBootstrapURL(sb.toString());
        }
    }

    private static InetAddress findLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (!addr.isLoopbackAddress()) continue;
                return addr;
            }
        }
        return null;
    }
}

