/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.util.HashSet;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.annotation.creator.AnnotationContext;
import org.jboss.metadata.annotation.creator.web.Web30MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.scanning.web.spi.ResourcesIndex;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarAnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();

    public WarAnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(WebMetaData.class);
        this.addInput(ResourcesIndex.class);
        this.addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        if (!unit.getSimpleName().endsWith(".war")) {
            return;
        }
        VirtualFile root = unit.getRoot();
        if (root.isFile()) {
            return;
        }
        List classpath = unit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Deploying annotations for unit: " + unit + ", classpath: " + classpath));
        }
        try {
            this.processMetaData(unit, classpath);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot process metadata", (Throwable)e);
        }
    }

    protected void processMetaData(VFSDeploymentUnit unit, List<VirtualFile> classpath) throws Exception {
        ResourcesIndex ri = (ResourcesIndex)unit.getAttachment(ResourcesIndex.class);
        if (ri == null) {
            return;
        }
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        Web30MetaDataCreator creator = new Web30MetaDataCreator((AnnotationFinder)finder);
        HashSet annotations = new HashSet();
        AnnotationContext annotationContext = creator.getAnnotationContext();
        if (annotationContext.getTypeAnnotations() != null) {
            annotations.addAll(annotationContext.getTypeAnnotations());
        }
        if (annotationContext.getMethodAnnotations() != null) {
            annotations.addAll(annotationContext.getMethodAnnotations());
        }
        if (annotationContext.getFieldAnnotations() != null) {
            annotations.addAll(annotationContext.getFieldAnnotations());
        }
        boolean metaData = false;
        for (VirtualFile path : classpath) {
            HashSet annotatedClasses = new HashSet();
            for (Class annotation : annotations) {
                annotatedClasses.addAll(ri.getAnnotatedClasses(path, annotation));
            }
            Web30MetaData annotationMetaData = creator.create(annotatedClasses);
            if (annotationMetaData == null) continue;
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME + ":" + path.getName(), (Object)annotationMetaData, WebMetaData.class);
            metaData = true;
        }
        if (metaData) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)Boolean.TRUE);
        }
    }
}

