/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.kernel;

import org.jboss.spring.kernel.Locator;
import org.jboss.spring.kernel.MicrocontainerLocatorSupport;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;

public class LazyLocator
extends MicrocontainerLocatorSupport
implements Locator {
    public Object locateBean(String beanName, Class targetType) {
        LocatorTargetSource targetSource = new LocatorTargetSource(beanName, targetType);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(targetType);
        proxyFactory.setTargetSource((TargetSource)targetSource);
        return proxyFactory.getProxy();
    }

    private class LocatorTargetSource
    implements TargetSource {
        private String beanName;
        private Class targetClass;
        private Object cachedObject;

        public LocatorTargetSource(String beanName, Class targetClass) {
            this.beanName = beanName;
            this.targetClass = targetClass;
        }

        public Class getTargetClass() {
            return this.cachedObject != null ? this.cachedObject.getClass() : this.targetClass;
        }

        public boolean isStatic() {
            return this.cachedObject != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getTarget() throws Exception {
            LocatorTargetSource locatorTargetSource = this;
            synchronized (locatorTargetSource) {
                if (this.cachedObject == null) {
                    this.cachedObject = LazyLocator.this.locateBean(this.beanName, this.targetClass);
                }
                return this.cachedObject;
            }
        }

        public void releaseTarget(Object target) {
        }
    }
}

