/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployers;

import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.spring.deployers.SpringMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringParserDeployer
extends AbstractVFSParsingDeployer<SpringMetaData> {
    private boolean useLegacyDefaultName;

    public SpringParserDeployer() {
        super(SpringMetaData.class);
        this.setSuffix("-spring.xml");
        this.setJarExtension(".spring");
        this.setUseLegacyDefaultName(false);
    }

    protected boolean isUseLegacyDefaultName() {
        return this.useLegacyDefaultName;
    }

    public void setUseLegacyDefaultName(boolean useLegacyDefaultName) {
        this.useLegacyDefaultName = useLegacyDefaultName;
    }

    protected String getDefaultName(VirtualFile file) {
        String shortName = file.getName();
        int p = shortName.indexOf("-spring.xml");
        return shortName.substring(0, p);
    }

    protected String getDefaultName(VFSDeploymentUnit unit) {
        String shortName = unit.getSimpleName();
        int p = shortName.lastIndexOf(".");
        return shortName.substring(0, p);
    }

    protected SpringMetaData parse(VFSDeploymentUnit unit, VirtualFile file, SpringMetaData metaData) throws Exception {
        String defaultName = this.isUseLegacyDefaultName() ? this.getDefaultName(unit) : this.getDefaultName(file);
        return new SpringMetaData(file.toURL(), defaultName);
    }
}

