/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.kernel;

import org.jboss.spring.kernel.MicrocontainerLocatorSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.core.Ordered;

public class MicrocontainerConfigurer
extends MicrocontainerLocatorSupport
implements BeanFactoryPostProcessor,
BeanNameAware,
BeanFactoryAware,
Ordered {
    private String beanName;
    private BeanFactory beanFactory;
    private int order = Integer.MAX_VALUE;
    private String prefix = "mc${";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactoryToProcess) throws BeansException {
        MicrocontainerBeanDefinitionVisitor visitor = new MicrocontainerBeanDefinitionVisitor();
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            if (beanNames[i].equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
            try {
                visitor.visitBeanDefinition(bd);
                continue;
            }
            catch (BeanDefinitionStoreException ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
            }
        }
    }

    protected boolean isMicrocontainerRef(String value) {
        return value != null && value.startsWith(this.prefix);
    }

    protected String parseBeansReference(String value) {
        int endIndex = value.lastIndexOf("$");
        endIndex = endIndex >= 0 ? endIndex : value.length();
        return value.substring(this.prefix.length(), endIndex);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private class MicrocontainerBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private MicrocontainerBeanDefinitionVisitor() {
        }

        protected String resolveStringValue(String strVal) {
            return strVal;
        }

        protected Object resolveValue(Object value) {
            String beansRef;
            TypedStringValue typedStringValue;
            String beansRef2;
            if ((value = super.resolveValue(value)) instanceof TypedStringValue && MicrocontainerConfigurer.this.isMicrocontainerRef(beansRef2 = (typedStringValue = (TypedStringValue)value).getValue())) {
                return MicrocontainerConfigurer.this.locateBean(MicrocontainerConfigurer.this.parseBeansReference(beansRef2));
            }
            if (value instanceof String && MicrocontainerConfigurer.this.isMicrocontainerRef(beansRef = (String)value)) {
                return MicrocontainerConfigurer.this.locateBean(MicrocontainerConfigurer.this.parseBeansReference(beansRef));
            }
            return value;
        }
    }
}

