/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.spring.factory.Nameable;
import org.jboss.spring.loader.BeanFactoryLoader;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@Deprecated
public abstract class AbstractBeanFactoryLoader
implements BeanFactoryLoader {
    private final Logger log = Logger.getLogger(this.getClass());
    protected Map beanFactoryNamesMap = new TreeMap();

    private URL getDocUrl(DeploymentInfo di) throws DeploymentException {
        URL docURL = di.localUrl;
        if (!di.isXML) {
            URLClassLoader localCL = di.localCl;
            docURL = localCL.findResource("META-INF/jboss-spring.xml");
        }
        if (docURL == null) {
            throw new DeploymentException("Failed to find META-INF/jboss-spring.xml");
        }
        return docURL;
    }

    private String getDefaultName(DeploymentInfo di) {
        String shortName = di.shortName;
        int p = shortName.indexOf(".spring");
        if (p > 0) {
            return shortName.substring(0, p);
        }
        p = shortName.indexOf("-spring.xml");
        if (p > 0) {
            return shortName.substring(0, p);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(DeploymentInfo di) throws DeploymentException {
        URL docURL = this.getDocUrl(di);
        String defaultName = this.getDefaultName(di);
        BeanFactory beanFactory = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)di.ucl);
            beanFactory = this.createBeanFactory(defaultName, (Resource)new UrlResource(docURL));
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        String name = ((Nameable)beanFactory).getName();
        AbstractBeanFactoryLoader.bind(beanFactory, name);
        this.log.info((Object)("Bean factory [" + name + "] binded to local JNDI."));
        this.beanFactoryNamesMap.put(docURL.toString(), name);
    }

    protected abstract BeanFactory createBeanFactory(String var1, Resource var2);

    public void start(DeploymentInfo di) throws DeploymentException {
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        try {
            URL docURL = this.getDocUrl(di);
            String name = (String)this.beanFactoryNamesMap.remove(docURL.toString());
            BeanFactory beanFactory = this.lookup(name);
            this.doClose(beanFactory);
            AbstractBeanFactoryLoader.unbind(name);
            this.log.info((Object)("Bean factory [" + name + "] unbinded from local JNDI."));
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected abstract void doClose(BeanFactory var1);

    public void destroy(DeploymentInfo di) throws DeploymentException {
    }

    public static void bind(BeanFactory beanFactory, String name) throws BeansException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            NonSerializableFactory.rebind((Context)ctx, (String)name, (Object)beanFactory);
        }
        catch (NamingException e) {
            throw new FatalBeanException("Unable to bind BeanFactory into JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    public static void unbind(String name) throws BeansException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            ctx.unbind(name);
            NonSerializableFactory.unbind((String)name);
        }
        catch (NamingException e) {
            throw new FatalBeanException("Unable to unbind BeanFactory from JNDI", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    public BeanFactory lookup(String name) throws Exception {
        BeanFactory beanFactory = (BeanFactory)Util.lookup((String)name, (Class)this.getExactBeanFactoryClass());
        this.log.debug((Object)("Found Spring bean factory [" + name + "]: " + beanFactory));
        return beanFactory;
    }

    protected abstract Class getExactBeanFactoryClass();
}

