/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.io;

import java.net.URL;
import org.jboss.spring.io.VFSResource;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class VFSResourceLoader
extends DefaultResourceLoader {
    public VFSResourceLoader() {
    }

    public VFSResourceLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL url = new URL(location);
            VirtualFile file = VFS.getCachedFile((URL)url);
            return new VFSResource(file);
        }
        catch (Exception ex) {
            return this.getResourceByPath(location);
        }
    }
}

