/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.system;

import javax.management.MBeanServer;
import javax.management.ObjectName;

/**
 * The ServiceFactory interface is used to obtain a Service
 * proxy instance for a named MBean.
 * 
 * @author <a href="mailto:Scott_Stark@displayscape.com">Scott Stark</a>.
 * @version $Revision: 57108 $
 */
public interface ServiceFactory
{
   /**
    * Create a Service proxy instance for the MBean given by name.
    * 
    * @param server    The MBeanServer instance
    * @param name      The name of the MBean that wishes to be managed by
    *                  the JBoss ServiceControl service.
    */
   Service createService(MBeanServer server, ObjectName name);
}
