/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceBinding;
import org.jboss.system.ServiceConfigurator;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.system.microcontainer.LifecycleDependencyItem;
import org.jboss.system.microcontainer.ServiceControllerContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceController
extends JBossNotificationBroadcasterSupport
implements ServiceControllerMBean,
MBeanRegistration {
    public static final ObjectName DEFAULT_LOADER_REPOSITORY = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    public static final String JBOSS_INTERNAL_LIFECYCLE = "jbossInternalLifecycle";
    public static final String[] JBOSS_INTERNAL_LIFECYCLE_SIG = new String[]{String.class.getName()};
    private static final Logger log = Logger.getLogger(ServiceController.class);
    protected Kernel kernel;
    protected MBeanServer server;
    protected ServiceBinding serviceBinding;
    protected Map<ObjectName, ServiceControllerContext> installed = new ConcurrentHashMap<ObjectName, ServiceControllerContext>();
    protected CopyOnWriteArrayList<ServiceControllerContext> installedOrder = new CopyOnWriteArrayList();

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public ServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    @Override
    public void setServiceBinding(ServiceBinding serviceBinding) {
        this.serviceBinding = serviceBinding;
    }

    @Override
    public List<ServiceContext> listDeployed() {
        ArrayList<ServiceContext> result = new ArrayList<ServiceContext>(this.installedOrder.size());
        for (ServiceControllerContext context : this.installedOrder) {
            result.add(context.getServiceContext());
        }
        return result;
    }

    @Override
    public List<ServiceContext> listIncompletelyDeployed() {
        ArrayList<ServiceContext> result = new ArrayList<ServiceContext>();
        for (ServiceControllerContext context : this.installedOrder) {
            ServiceContext sc = context.getServiceContext();
            if (sc.state == 2 || sc.state == 3 || sc.state == 5 || sc.state == 6) continue;
            result.add(sc);
        }
        return result;
    }

    @Override
    public List<ObjectName> listDeployedNames() {
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(this.installed.size());
        for (ObjectName name : this.installed.keySet()) {
            result.add(name);
        }
        return result;
    }

    @Override
    public String listConfiguration(ObjectName[] objectNames) throws Exception {
        return ServiceConfigurator.getConfiguration(this.server, this, objectNames);
    }

    @Override
    public void validateDeploymentState(DeploymentInfo di, DeploymentState state) {
        ArrayList<ObjectName> mbeans = new ArrayList<ObjectName>(di.mbeans);
        if (di.deployedObject != null) {
            mbeans.add(di.deployedObject);
        }
        boolean mbeansStateIsValid = true;
        for (int m = 0; m < mbeans.size(); ++m) {
            ObjectName serviceName = mbeans.get(m);
            ServiceContext ctx = this.getServiceContext(serviceName);
            if (ctx == null || state != DeploymentState.STARTED) continue;
            mbeansStateIsValid &= ctx.state == 3;
        }
        if (mbeansStateIsValid) {
            di.state = state;
        }
    }

    public List<ObjectName> install(List<ServiceMetaData> metaDatas, ObjectName loaderName) throws DeploymentException {
        KernelController controller = this.kernel.getController();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(metaDatas.size());
        ArrayList<ServiceControllerContext> contexts = new ArrayList<ServiceControllerContext>(metaDatas.size());
        for (ServiceMetaData metaData : metaDatas) {
            metaData.setClassLoaderName(loaderName);
            ServiceControllerContext context = new ServiceControllerContext(this, metaData);
            try {
                this.doInstall(controller, context);
                contexts.add(context);
                this.doChange(controller, context, ControllerState.CONFIGURED, "configure");
                result.add(context.getObjectName());
            }
            catch (Throwable t) {
                for (ServiceControllerContext ctx : contexts) {
                    this.safelyRemoveAnyRegisteredContext(ctx);
                }
                DeploymentException.rethrowAsDeploymentException("Error during install", t);
            }
        }
        return result;
    }

    public ObjectName install(ServiceMetaData metaData, ObjectName loaderName) throws DeploymentException {
        KernelController controller = this.kernel.getController();
        metaData.setClassLoaderName(loaderName);
        ObjectName name = metaData.getObjectName();
        ServiceControllerContext context = new ServiceControllerContext(this, metaData);
        try {
            this.doInstall(controller, context);
            this.doChange(controller, context, ControllerState.CONFIGURED, "configure");
            return context.getObjectName();
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException("Error during install " + name, t);
        }
    }

    @Override
    public List<ObjectName> install(Element config, ObjectName loaderName) throws DeploymentException {
        ServiceMetaDataParser parser = new ServiceMetaDataParser(config);
        List<ServiceMetaData> metaDatas = parser.parse();
        return this.install(metaDatas, loaderName);
    }

    public void install(ObjectName name, Object object) throws DeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        KernelController controller = this.kernel.getController();
        ServiceControllerContext context = new ServiceControllerContext(this, name, object);
        try {
            this.doInstall(controller, context);
            this.doChange(controller, context, ControllerState.CONFIGURED, "configure");
        }
        catch (Throwable t) {
            this.safelyRemoveAnyRegisteredContext(context);
            DeploymentException.rethrowAsDeploymentException("Error during install", t);
        }
    }

    @Override
    public void register(ObjectName serviceName) throws Exception {
        this.register(serviceName, null);
    }

    @Override
    public void register(ObjectName serviceName, Collection<ObjectName> depends) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to register null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("Registering service " + serviceName));
        KernelController controller = this.kernel.getController();
        ServiceControllerContext context = new ServiceControllerContext(this, serviceName);
        if (depends != null) {
            this.addDependencies(context, depends);
        }
        try {
            this.doInstall(controller, context);
            this.doChange(controller, context, ControllerState.CONFIGURED, "configure");
        }
        catch (Throwable t) {
            this.safelyRemoveAnyRegisteredContext(context);
            DeploymentException.rethrowAsDeploymentException("Error during register: " + serviceName, t);
        }
    }

    @Override
    public void create(ObjectName serviceName) throws Exception {
        this.create(serviceName, null);
    }

    @Override
    public void create(ObjectName serviceName, Collection<ObjectName> depends) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to create null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("Creating service " + serviceName));
        ServiceControllerContext context = this.installed.get(serviceName);
        if (context == null) {
            this.register(serviceName, depends);
            context = this.installed.get(serviceName);
        }
        ServiceContext ctx = context.getServiceContext();
        if (ctx.state == 2 || ctx.state == 3 || ctx.state == 4) {
            log.debug((Object)("Ignoring create request for service: " + ctx.objectName + " at state " + ctx.getStateString()));
            return;
        }
        KernelController controller = this.kernel.getController();
        try {
            this.doChange(controller, context, ControllerState.CREATE, "create");
        }
        catch (Throwable t) {
            log.warn((Object)("Problem creating service " + serviceName), t);
        }
    }

    @Override
    public void start(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to start null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("starting service " + serviceName));
        ServiceControllerContext context = this.installed.get(serviceName);
        if (context == null) {
            this.register(serviceName, null);
            context = this.installed.get(serviceName);
        }
        ServiceContext ctx = context.getServiceContext();
        if (ctx.state == 3 || ctx.state == 4) {
            log.debug((Object)("Ignoring start request for service: " + ctx.objectName + " at state " + ctx.getStateString()));
            return;
        }
        KernelController controller = this.kernel.getController();
        try {
            this.doChange(controller, context, ControllerState.INSTALLED, "start");
        }
        catch (Throwable t) {
            log.warn((Object)("Problem starting service " + serviceName), t);
        }
    }

    @Override
    public void restart(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to restart null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("restarting service " + serviceName));
        this.stop(serviceName);
        this.start(serviceName);
    }

    @Override
    public void stop(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to stop null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("stopping service: " + serviceName));
        ServiceControllerContext context = this.installed.get(serviceName);
        if (context == null) {
            log.warn((Object)("Ignoring request to stop nonexistent service: " + serviceName));
            return;
        }
        ServiceContext ctx = context.getServiceContext();
        if (ctx.state != 3) {
            log.debug((Object)("Ignoring stop request for service: " + ctx.objectName + " at state " + ctx.getStateString()));
            return;
        }
        KernelController controller = this.kernel.getController();
        try {
            this.doChange(controller, context, ControllerState.CREATE, null);
        }
        catch (Throwable t) {
            log.warn((Object)("Problem stopping service " + serviceName), t);
        }
    }

    @Override
    public void destroy(ObjectName serviceName) throws Exception {
        if (serviceName == null) {
            log.warn((Object)"Ignoring request to destroy null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        log.debug((Object)("destroying service: " + serviceName));
        ServiceControllerContext context = this.installed.get(serviceName);
        if (context == null) {
            log.warn((Object)("Ignoring request to destroy nonexistent service: " + serviceName));
            return;
        }
        ServiceContext ctx = context.getServiceContext();
        if (ctx.state == 6 || ctx.state == 7 || ctx.state == 4) {
            log.debug((Object)("Ignoring destroy request for service: " + ctx.objectName + " at state " + ctx.getStateString()));
            return;
        }
        KernelController controller = this.kernel.getController();
        try {
            this.doChange(controller, context, ControllerState.CONFIGURED, null);
        }
        catch (Throwable t) {
            log.warn((Object)("Problem stopping service " + serviceName), t);
        }
    }

    @Override
    public void remove(ObjectName objectName) throws Exception {
        if (objectName == null) {
            log.warn((Object)"Ignoring request to remove null service: ", (Throwable)new Exception("STACKTRACE"));
            return;
        }
        ServiceControllerContext context = this.installed.remove(objectName);
        if (context == null) {
            log.trace((Object)("Ignoring request to remove nonexistent service: " + objectName));
            return;
        }
        this.installedOrder.remove((Object)context);
        log.debug((Object)("removing service: " + objectName));
        this.safelyRemoveAnyRegisteredContext(context);
    }

    @Override
    public ServiceContext getServiceContext(ObjectName serviceName) {
        ServiceControllerContext context = this.installed.get(serviceName);
        if (context != null) {
            return context.getServiceContext();
        }
        return null;
    }

    @Override
    public void shutdown() {
        log.debug((Object)("Stopping " + this.installedOrder.size() + " services"));
        KernelController controller = this.kernel.getController();
        int serviceCounter = 0;
        ListIterator<ServiceControllerContext> iterator = this.installedOrder.listIterator(this.installedOrder.size());
        while (iterator.hasPrevious()) {
            ServiceControllerContext context = iterator.previous();
            controller.uninstall(context.getName());
            ++serviceCounter;
        }
        log.debug((Object)("Stopped " + serviceCounter + " services"));
        controller.uninstall((Object)ServiceControllerMBean.OBJECT_NAME.getCanonicalName());
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        if (this.kernel == null) {
            BasicBootstrap bootstrap = new BasicBootstrap();
            bootstrap.run();
            this.kernel = bootstrap.getKernel();
        }
        log.debug((Object)"Controller MBean online");
        return name == null ? OBJECT_NAME : name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            log.fatal((Object)"Registration of ServiceController failed");
        } else {
            KernelController controller = this.kernel.getController();
            ServiceControllerContext context = new ServiceControllerContext(this, ServiceControllerMBean.OBJECT_NAME);
            context.setMode(ControllerMode.AUTOMATIC);
            try {
                controller.install((ControllerContext)context);
            }
            catch (Throwable t) {
                log.fatal((Object)"Error registering service controller", t);
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.installed.clear();
        this.installedOrder.clear();
        this.server = null;
    }

    private void doInstall(KernelController controller, ServiceControllerContext context) throws Throwable {
        controller.install((ControllerContext)context);
        this.installed.put(context.getObjectName(), context);
        this.installedOrder.add(context);
    }

    private void doChange(KernelController controller, ServiceControllerContext context, ControllerState requiredState, String logWait) throws Throwable {
        if (!ControllerMode.ON_DEMAND.equals((Object)context.getMode())) {
            controller.change((ControllerContext)context, requiredState);
            ControllerState state = context.getState();
            if (logWait != null && !requiredState.equals((Object)state) && state != ControllerState.ERROR) {
                log.debug((Object)("Waiting in " + logWait + " of " + context.getObjectName() + " on " + this.getUnresolvedDependencies(context, requiredState)));
            }
        }
    }

    public void sendControllerNotification(String type, ObjectName serviceName) {
        Notification notification = new Notification(type, this, super.nextNotificationSequenceNumber());
        notification.setUserData(serviceName);
        this.sendNotification(notification);
    }

    private void addDependencies(ServiceControllerContext context, Collection<ObjectName> depends) {
        DependencyInfo info = context.getDependencyInfo();
        for (ObjectName other : depends) {
            info.addIDependOn((DependencyItem)new LifecycleDependencyItem(context.getName(), other.getCanonicalName(), ControllerState.CREATE));
            info.addIDependOn((DependencyItem)new LifecycleDependencyItem(context.getName(), other.getCanonicalName(), ControllerState.START));
        }
    }

    private String getUnresolvedDependencies(ServiceControllerContext context, ControllerState state) {
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (DependencyItem item : context.getDependencyInfo().getUnresolvedDependencies()) {
            if (item.isResolved() || item.getWhenRequired() != state) continue;
            if (first) {
                first = false;
            } else {
                builder.append(' ');
            }
            builder.append(item.getIDependOn());
        }
        return builder.toString();
    }

    private void safelyRemoveAnyRegisteredContext(ServiceControllerContext ctx) {
        Object name;
        ControllerContext registered;
        Controller controller = ctx.getController();
        if (controller != null && (registered = controller.getContext(name = ctx.getName(), null)) == ctx) {
            controller.uninstall(name);
        }
    }
}

