/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.system.deployers.SARArchiveFilter;
import org.jboss.system.deployers.managed.ServiceMetaDataICF;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceDeploymentClassPath;
import org.jboss.system.metadata.ServiceDeploymentParser;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SARDeployer
extends JAXPDeployer<ServiceDeployment> {
    private ServiceMetaDataICF icf;

    public SARDeployer() {
        super(ServiceDeployment.class);
        this.setSuffix("-service.xml");
        this.setBuildManagedObject(true);
    }

    public ServiceMetaDataICF getIcf() {
        return this.icf;
    }

    public void setIcf(ServiceMetaDataICF icf) {
        this.icf = icf;
        if (icf != null) {
            ManagedObjectFactory mof = ManagedObjectFactory.getInstance();
            mof.setInstanceClassFactory(ServiceMetaData.class, (InstanceClassFactory)icf);
        }
    }

    protected ServiceDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document) throws Exception {
        LoaderRepositoryFactory.LoaderRepositoryConfig config;
        ServiceDeploymentParser parser = new ServiceDeploymentParser(document);
        ServiceDeployment parsed = parser.parse();
        String name = file.toURI().toString();
        parsed.setName(name);
        List<ServiceDeploymentClassPath> classPaths = parsed.getClassPaths();
        if (classPaths != null) {
            this.processXMLClasspath(unit, classPaths);
        }
        if ((config = parsed.getLoaderRepositoryConfig()) != null) {
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class.getName(), (Object)config);
        }
        return parsed;
    }

    private void processXMLClasspath(VFSDeploymentUnit unit, List<ServiceDeploymentClassPath> classpaths) throws Exception {
        ArrayList<VirtualFile> classpath = new ArrayList<VirtualFile>();
        for (ServiceDeploymentClassPath path : classpaths) {
            String codebase = path.getCodeBase();
            String archives = path.getArchives();
            this.log.debug((Object)("Processing classpath: " + unit.getName() + " codebase=" + codebase + " archives=" + archives));
            VirtualFile codebaseFile = unit.getRoot();
            if (!".".equals(codebase)) {
                ServerConfig config = ServerConfigLocator.locate();
                URL codeBaseURL = new URL(config.getServerHomeURL(), codebase);
                codebaseFile = VFS.getVirtualFile((URL)codeBaseURL, (String)"");
            }
            if (codebaseFile == null) {
                throw new DeploymentException("Cannot use classpath without a root: " + unit.getName());
            }
            if (archives == null) {
                classpath.add(codebaseFile);
                this.log.debug((Object)("Using codebase as classpath: " + unit.getName()));
                continue;
            }
            SARArchiveFilter filter = new SARArchiveFilter(archives);
            List archiveFiles = codebaseFile.getChildren((VirtualFileFilter)filter);
            classpath.addAll(archiveFiles);
        }
        List origClassPath = unit.getClassPath();
        if (origClassPath != null) {
            classpath.addAll(origClassPath);
        }
        unit.setClassPath(classpath);
    }
}

