/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers.managed;

import java.io.Serializable;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.system.deployers.managed.ManagementObjectClass;
import org.jboss.system.metadata.ServiceAnnotationMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetaDataICF
implements InstanceClassFactory<ServiceMetaData> {
    private static final Logger log = Logger.getLogger(ServiceMetaDataICF.class);
    private static final String MOCLASS_ANNOTATION = '@' + ManagementObjectClass.class.getName();
    private MBeanServer mbeanServer;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public Class<? extends Serializable> getManagedObjectClass(ServiceMetaData md) throws ClassNotFoundException {
        try {
            ClassLoader loader = null;
            if (this.mbeanServer != null) {
                loader = this.mbeanServer.getClassLoader(md.getClassLoaderName());
            }
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            Class moClass = loader.loadClass(md.getCode());
            List<ServiceAnnotationMetaData> samlist = md.getAnnotations();
            for (ServiceAnnotationMetaData sam : samlist) {
                String anString = sam.getAnnotation();
                if (!anString.startsWith(MOCLASS_ANNOTATION)) continue;
                Class originalClass = moClass;
                ManagementObjectClass moc = (ManagementObjectClass)sam.getAnnotationInstance(loader);
                moClass = moc.code();
                log.debug((Object)("Using alternate class '" + moClass + "' for class " + originalClass));
                break;
            }
            return moClass;
        }
        catch (InstanceNotFoundException e) {
            throw new ClassNotFoundException("Failed to obtain mbean class loader", e);
        }
    }

    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md) {
        MetaValue mvalue;
        String name = property.getMappedName();
        if (name == null) {
            property.getName();
        }
        Object value = null;
        for (ServiceAttributeMetaData amd : md.getAttributes()) {
            if (!amd.getName().equalsIgnoreCase(name)) continue;
            value = amd.getValue();
            break;
        }
        if (value instanceof ServiceTextValueMetaData) {
            ServiceTextValueMetaData text = (ServiceTextValueMetaData)value;
            value = text.getText();
        } else if (value instanceof ServiceDependencyValueMetaData) {
            ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)value;
            value = depends.getDependency();
        }
        PropertyInfo propertyInfo = beanInfo.getProperty(name);
        try {
            mvalue = this.metaValueFactory.create(value, propertyInfo.getType());
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get property value for bean: " + beanInfo.getName() + ", property: " + propertyInfo.getName()), (Throwable)e);
            mvalue = this.metaValueFactory.create(null, propertyInfo.getType());
        }
        return mvalue;
    }

    public void setValue(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
        String name = property.getMappedName();
        if (name == null) {
            property.getName();
        }
        ServiceValueMetaData attributeValue = null;
        for (ServiceAttributeMetaData amd : md.getAttributes()) {
            if (!amd.getName().equalsIgnoreCase(name)) continue;
            attributeValue = amd.getValue();
            break;
        }
        if (attributeValue != null) {
            PropertyInfo propertyInfo = beanInfo.getProperty(name);
            Object plainValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
            if (attributeValue instanceof ServiceTextValueMetaData) {
                ServiceTextValueMetaData text = (ServiceTextValueMetaData)attributeValue;
                text.setText(String.valueOf(plainValue));
            } else if (value instanceof ServiceDependencyValueMetaData) {
                ServiceDependencyValueMetaData depends = (ServiceDependencyValueMetaData)attributeValue;
                depends.setDependency(String.valueOf(plainValue));
            }
        } else {
            throw new IllegalArgumentException("No matching attribute found: " + name + "/" + md);
        }
    }

    public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, ServiceMetaData md, MetaValue value) {
        ObjectName objectName;
        if ((beanInfo == null || property == null || value == null) && (objectName = md.getObjectName()) != null) {
            return objectName.getCanonicalName();
        }
        return null;
    }
}

