/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceDeploymentClassPath;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeploymentParser {
    private static final Logger log = Logger.getLogger(ServiceDeploymentParser.class);
    private Document document;

    public ServiceDeploymentParser(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Null document");
        }
        this.document = document;
    }

    public ServiceDeployment parse() throws DeploymentException {
        ServiceDeployment parsed = new ServiceDeployment();
        List<ServiceDeploymentClassPath> classPaths = this.parseXMLClasspath(this.document);
        parsed.setClassPaths(classPaths);
        LoaderRepositoryFactory.LoaderRepositoryConfig repository = this.parseLoaderRepositoryConfig(this.document);
        if (repository != null) {
            parsed.setLoaderRepositoryConfig(repository);
        }
        parsed.setConfig(this.document.getDocumentElement());
        return parsed;
    }

    private List<ServiceDeploymentClassPath> parseXMLClasspath(Document document) throws DeploymentException {
        ArrayList<ServiceDeploymentClassPath> classPaths = null;
        NodeList children = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element classpathElement;
            if (children.item(i).getNodeType() != 1 || !(classpathElement = (Element)children.item(i)).getTagName().equals("classpath")) continue;
            log.debug((Object)("Found classpath element: " + classpathElement));
            if (!classpathElement.hasAttribute("codebase")) {
                throw new DeploymentException("Invalid classpath element missing codebase: " + classpathElement);
            }
            String codebase = classpathElement.getAttribute("codebase").trim();
            codebase = StringPropertyReplacer.replaceProperties((String)codebase);
            String archives = null;
            if (classpathElement.hasAttribute("archives")) {
                archives = classpathElement.getAttribute("archives").trim();
                if ("".equals(archives = StringPropertyReplacer.replaceProperties((String)archives))) {
                    archives = null;
                }
            }
            if (classPaths == null) {
                classPaths = new ArrayList<ServiceDeploymentClassPath>();
            }
            ServiceDeploymentClassPath classPath = new ServiceDeploymentClassPath(codebase, archives);
            classPaths.add(classPath);
        }
        return classPaths;
    }

    private LoaderRepositoryFactory.LoaderRepositoryConfig parseLoaderRepositoryConfig(Document document) throws DeploymentException {
        NodeList loaders = document.getElementsByTagName("loader-repository");
        if (loaders.getLength() > 0) {
            Element loader = (Element)loaders.item(0);
            try {
                return LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException("Unable to parse loader repository config", e);
            }
        }
        return null;
    }
}

