/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.system.metadata.ServiceDeploymentClassPath;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeploymentClasspathAdapter
extends XmlAdapter<Object, ServiceDeploymentClassPath> {
    public ServiceDeploymentClassPath unmarshal(Object e) throws Exception {
        Element classpathElement = (Element)e;
        if (!classpathElement.hasAttribute("codebase")) {
            throw new DeploymentException("Invalid classpath element missing codebase: " + classpathElement);
        }
        String codebase = classpathElement.getAttribute("codebase").trim();
        codebase = StringPropertyReplacer.replaceProperties((String)codebase);
        String archives = null;
        if (classpathElement.hasAttribute("archives")) {
            archives = classpathElement.getAttribute("archives").trim();
            if ("".equals(archives = StringPropertyReplacer.replaceProperties((String)archives))) {
                archives = null;
            }
        }
        return new ServiceDeploymentClassPath(codebase, archives);
    }

    public Object marshal(ServiceDeploymentClassPath path) throws Exception {
        if (path == null) {
            return null;
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element classPath = document.createElement("classpath");
        classPath.setAttribute("codebase", path.getCodeBase());
        classPath.setAttribute("archives", path.getArchives());
        return classPath;
    }
}

