/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.aop.deployers.temp;

import java.lang.reflect.Field;

import org.jboss.aop.microcontainer.beans.xml.AOPBeansSchemaInitializer;
import org.jboss.aop.microcontainer.integration.AOPDependencyBuilder;
import org.jboss.aop.microcontainer.integration.AOPJoinpointFactoryBuilder;
import org.jboss.config.plugins.AbstractConfiguration;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.AbstractKernelConfig;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

/**
 * This is a hack to fix the problems caused
 * by aop-mc-int not being in the same classloader
 * as the mc and jbossxb.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class Hack
{
   public Hack(Kernel kernel) throws Exception
   {
      KernelConfig config = kernel.getConfig();
      Class<?> clazz = AbstractKernelConfig.class;
      Field field = clazz.getDeclaredField("configuration");
      field.setAccessible(true);

      Object object = field.get(config);
      clazz = AbstractConfiguration.class;
      field = clazz.getDeclaredField("joinpointFactoryBuilder");
      field.setAccessible(true);
      field.set(object, new AOPJoinpointFactoryBuilder());      

      field = clazz.getDeclaredField("dependencyBuilder");
      field.setAccessible(true);
      field.set(object, new AOPDependencyBuilder());
      
      DefaultSchemaResolver resolver = (DefaultSchemaResolver) SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
      resolver.addSchemaInitializer("urn:jboss:aop-beans:1.0", new AOPBeansSchemaInitializer());
      resolver.addSchemaParseAnnotations("urn:jboss:aop-beans:1.0", Boolean.FALSE);
   }
}
