/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.spi;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipInputStream;

import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;

/**
 * An interface for managing the contents of a Profile.
 * 
 * @author Scott.Stark@jboss.org
 * @author adrian@jboss.org
 * @version $Revision:$
 */
public interface DeploymentRepository
{
   public void create() throws Exception;
   public void load() throws Exception;
   public void remove() throws Exception;
   public long getLastModified();

   public URI getDeploymentURI(DeploymentPhase phase);
   public void setDeploymentURI(URI uri, DeploymentPhase phase);

   public Set<String> getDeploymentNames();
   public Set<String> getDeploymentNames(DeploymentPhase phase);
   public Set<String> getDeploymentNamesForType(String type);

   // Upload a raw deployment
   public void addDeploymentContent(String name, ZipInputStream contentIS, DeploymentPhase phase)
      throws IOException;

   /**
    * Add a deployment
    * 
    * @param vfsPath the path
    * @param d the deployment
    * @param phase - the phase of the deployment as it relates to when the
    * deployment is loaded
    * @throws Exception for any error
    */
   public void addDeployment(String vfsPath, VFSDeployment d, DeploymentPhase phase)
      throws Exception;
   public void updateDeployment(String vfsPath, VFSDeployment d, DeploymentPhase phase)
      throws Exception;
   /**
    * Get a named deployment.
    * 
    * @param name - the deployment name
    * @param phase - the phase of the deployment as it relates to when the
    * deployment is loaded
    * @return the named bootstrap
    * @throws NoSuchDeploymentException - if there is no such bootstrap
    * @throws IOException 
    * @throws Exception for any error
    */
   public VFSDeployment getDeployment(String name, DeploymentPhase phase)
      throws NoSuchDeploymentException, Exception;

   /**
    * Remove a deployment
    * 
    * @param vfsPath - the vfs path
    * @param phase - the phase of the deployment as it relates to when the
    * deployment is loaded
    * @return the removed deployment
    * @throws Exception for any error
    */
   public VFSDeployment removeDeployment(String vfsPath, DeploymentPhase phase)
      throws Exception;

   /**
    * Get all deployments for the given phase defined in this profile
    * 
    * @param phase - the phase of the deployment as it relates to when the
    * deployment is loaded
    * @return the bootstrap instances in this profile.
    * @throws Exception for any error
    */
   public Collection<VFSDeployment> getDeployments(DeploymentPhase phase)
      throws Exception;
   /**
    * Get all deployments defined in this profile
    * 
    * @return the deployment instances in this profile.
    * @throws Exception for any error
    */
   public Collection<VFSDeployment> getDeployments()
      throws Exception;

   public Collection<ModificationInfo> getModifiedDeployments()
      throws Exception;

   // Managed object attachments for a deployment
   public void addManagedObject(String vfsPath, Attachments edits)
      throws Exception;

}
