/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.net.URI;

import org.jboss.profileservice.spi.AttachmentsSerializer;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.ProfileKey;

/**
 * Factory for SerializableDeploymentRepository
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class SerializableDeploymentRepositoryFactory
   implements DeploymentRepositoryFactory
{
   /** The server root container the deployments */
   private File root;
   /** The URIs for the application deployments */
   private URI[] appURIs = {};
   /** */
   private AttachmentsSerializer serializer;

   /**
    * Get the server profile store root directory.
    * @return the server profile root directory containing the
    * available profiles.
    */
   public File getStoreRoot()
   {
      return root;
   }
   /**
    * Set the profiles store root.
    * @param root - the server profile root directory containing the
    * available profiles.
    */
   public void setStoreRoot(File root)
   {
      this.root = root;
   }

   public URI[] getApplicationURIs()
   {
      return appURIs;
   }
   public void setApplicationURIs(URI[] appURIs)
   {
      this.appURIs = appURIs;
   }

   public AttachmentsSerializer getSerializer()
   {
      return serializer;
   }

   public void setSerializer(AttachmentsSerializer serializer)
   {
      this.serializer = serializer;
   }

   public DeploymentRepository getDeploymentRepository(ProfileKey key)
   {
      if (appURIs == null || appURIs.length == 0)
      {
         File deployDir = new File(root, key.getName()+"/deploy");
         appURIs = new URI[]{deployDir.toURI()};
      }
      SerializableDeploymentRepository repo = new SerializableDeploymentRepository(root, appURIs, key);
      repo.setSerializer(serializer);
      return repo;
   }

}
