/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.profileservice.aop.TrackingAdvice;
import org.jboss.profileservice.spi.AttachmentsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileAttachmentsSerializer
implements AttachmentsSerializer {
    private static final Logger log = Logger.getLogger(AbstractFileAttachmentsSerializer.class);
    private File attachmentsStoreDir;

    public File getAttachmentsStoreDir() {
        return this.attachmentsStoreDir;
    }

    public void setAttachmentsStoreDir(File attachmentsStoreDir) {
        this.attachmentsStoreDir = attachmentsStoreDir;
    }

    @Override
    public Map<String, Object> loadAttachments(DeploymentUnit ctx, String deployerID, ClassLoader loader) throws Exception {
        if (this.attachmentsStoreDir == null) {
            throw new IllegalStateException("attachmentsStoreDir has not been set");
        }
        String vfsPath = ctx.getSimpleName();
        File deployerDir = new File(this.attachmentsStoreDir, deployerID);
        File attachmentsStore = new File(deployerDir, vfsPath = vfsPath + ".attachments");
        if (!attachmentsStore.exists()) {
            return null;
        }
        return this.loadAttachments(attachmentsStore, loader);
    }

    @Override
    public void saveAttachments(DeploymentUnit ctx, String deployerID, ClassLoader loader) throws Exception {
        File deployerDir;
        File attachmentsStore;
        File attachmentsParent;
        if (this.attachmentsStoreDir == null) {
            throw new IllegalStateException("attachmentsStoreDir has not been set");
        }
        String vfsPath = ctx.getSimpleName();
        if (vfsPath.length() == 0) {
            vfsPath = ctx.getSimpleName();
        }
        if (!(attachmentsParent = (attachmentsStore = new File(deployerDir = new File(this.attachmentsStoreDir, deployerID), vfsPath = vfsPath + ".attachments")).getParentFile()).exists() && !attachmentsParent.mkdirs()) {
            throw new IOException("Failed to create attachmentsParent: " + attachmentsParent.getAbsolutePath());
        }
        Map<String, Object> attachments = TrackingAdvice.clearAttachmentsForTarget(ctx.getTransientManagedObjects());
        if (attachments != null) {
            try {
                this.saveAttachments(attachmentsStore, attachments, loader);
            }
            catch (NotSerializableException e) {
                StringBuilder tmp = new StringBuilder("Save failed with NSE, attachments contents: ");
                for (Map.Entry<String, Object> entry : attachments.entrySet()) {
                    tmp.append(entry.getKey());
                    tmp.append('=');
                    tmp.append(entry.getValue());
                }
                log.error((Object)tmp.toString());
                throw e;
            }
        }
    }

    protected abstract Map<String, Object> loadAttachments(File var1, ClassLoader var2) throws Exception;

    protected abstract void saveAttachments(File var1, Map<String, Object> var2, ClassLoader var3) throws Exception;
}

