/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management.deploy;

import java.net.URL;

import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;

/**
 * An interface for uploading and controlling deployments in a profile.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public interface DeploymentManager
{
   /**
    * Load and associate the given profile with the DeploymentManager
    * for future operations.
    * 
    * @param key - the profile to load
    * @throws NoSuchProfileException
    */
   public void loadProfile(ProfileKey key)
      throws Exception;

   /**
    * Add raw deployment content to the profile.
    * 
    * @param name phase unique name
    * @param phase the phase this deployment applies to
    * @param contentURL - URL for obtaining the deployment archive
    * @return DeploymentProgress progress object for the deployment
    */
   public DeploymentProgress distribute(String name, DeploymentPhase phase,
         URL contentURL);

   /**
    * Map from the external name passed to distribute to the uploaded
    * deployment repository name.
    * @param names - the list of external deployment names
    * @return the mapped list of unique names in the deployment repository.
    */
   public String[] getRepositoryNames(String[] names, DeploymentPhase phase)
      throws Exception;

   public boolean isRedeploySupported();
   /**
    * 
    * @param name
    * @param phase
    * @param contentURL
    * @return
    */
   public DeploymentProgress redeploy(String name, DeploymentPhase phase,
         URL contentURL);

   /**
    * Validate a set of deployments through their dependency analysis phase.
    * @param phase
    * @param names the unique names of the deployments within the phase to prepare
    * @return a DeploymentProgress used to run and track the prepare progress.
    * @throws Exception
    */
   public DeploymentProgress prepare(DeploymentPhase phase, String... names)
      throws Exception;

   /**
    * Start a previously distributed deployment
    * @param phase
    * @param names the unique names of the deployments within the phase to prepare
    * @return
    * @throws Exception
    */
   public DeploymentProgress start(DeploymentPhase phase, String... names)
      throws Exception;
   public DeploymentProgress stop(DeploymentPhase phase, String... names)
      throws Exception;
   public DeploymentProgress undeploy(DeploymentPhase phase, String... names)
      throws Exception;
}
