/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.managed;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.deployers.spi.deployer.managed.ManagedDeploymentCreator;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.annotation.ManagementDeployment;
import org.jboss.managed.plugins.ManagedDeploymentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedManagedDeploymentCreator
implements ManagedDeploymentCreator {
    private static Logger log = Logger.getLogger(TypedManagedDeploymentCreator.class);
    private Map<Class, String> attachmentToTypeMap = new ConcurrentHashMap<Class, String>();
    private Map<Class, List<TypeVersion>> attachmentToTypeVersionsMap = new ConcurrentHashMap<Class, List<TypeVersion>>();

    public ManagedDeployment build(DeploymentUnit unit, Map<String, ManagedObject> unitMOs, ManagedDeployment parent) {
        Set knownTypes;
        if (unit.getSimpleName().startsWith("testEjb2xDeployment")) {
            log.info((Object)"Processing testEjb2xDeployment");
        }
        ManagedDeployment.DeploymentPhase phase = (ManagedDeployment.DeploymentPhase)unit.getAttachment(ManagedDeployment.DeploymentPhase.class);
        ManagementDeployment mdAnnotation = null;
        for (ManagedObject mo : unitMOs.values()) {
            Map annotations = mo.getAnnotations();
            if (annotations == null || mdAnnotation != null) continue;
            mdAnnotation = (ManagementDeployment)annotations.get(ManagementDeployment.class.getName());
        }
        String simpleName = unit.getSimpleName();
        String[] types = new String[]{};
        if (mdAnnotation != null) {
            if (phase == null) {
                phase = mdAnnotation.phase();
            }
            if (mdAnnotation.simpleName().length() > 0) {
                simpleName = mdAnnotation.simpleName();
            }
            types = mdAnnotation.types();
        }
        if (phase == null) {
            phase = ManagedDeployment.DeploymentPhase.APPLICATION;
        }
        ManagedDeploymentImpl md = new ManagedDeploymentImpl(unit.getName(), simpleName, phase, parent, unitMOs);
        if (types.length > 0) {
            for (String type : types) {
                this.addType((ManagedDeployment)md, type);
            }
        }
        if ((knownTypes = unit.getAllMetaData(KnownDeploymentTypes.class)) != null) {
            for (KnownDeploymentTypes type : knownTypes) {
                this.addType((ManagedDeployment)md, type.getType());
            }
        }
        for (Class attachmentType : this.attachmentToTypeMap.keySet()) {
            String type;
            if (!unit.isAttachmentPresent(attachmentType)) continue;
            type = this.attachmentToTypeMap.get(attachmentType);
            this.addType((ManagedDeployment)md, type);
        }
        for (Class attachmentType : this.attachmentToTypeVersionsMap.keySet()) {
            if (!unit.isAttachmentPresent(attachmentType)) continue;
            List<TypeVersion> versions = this.attachmentToTypeVersionsMap.get(attachmentType);
            Object attachment = unit.getAttachment(attachmentType);
            if (attachment == null) continue;
            for (TypeVersion tv : versions) {
                Matcher m;
                String version = this.getVersion(attachment, tv.versionGetter);
                if (version == null || !(m = tv.versionPattern.matcher(version)).matches()) continue;
                this.addType((ManagedDeployment)md, tv.type);
            }
        }
        return md;
    }

    public void addAttachmentType(Class attachmentType, String deploymentType) {
        log.debug((Object)("addAttachmentType, " + attachmentType + ":" + deploymentType));
        this.attachmentToTypeMap.put(attachmentType, deploymentType);
    }

    public void addVersionedAttachmentType(Class attachmentType, String deploymentType, String versionPattern) {
        this.addVersionedAttachmentType(attachmentType, deploymentType, versionPattern, "getVersion");
    }

    public void addVersionedAttachmentType(Class attachmentType, String deploymentType, String versionPattern, String versionGetterName) {
        Pattern p = Pattern.compile(versionPattern);
        log.debug((Object)("addVersionedAttachmentType, " + attachmentType + ":" + deploymentType + ", version: " + versionPattern));
        TypeVersion tv = new TypeVersion(deploymentType, p, versionGetterName);
        List<TypeVersion> tvlist = this.attachmentToTypeVersionsMap.get(attachmentType);
        if (tvlist == null) {
            tvlist = new ArrayList<TypeVersion>();
            this.attachmentToTypeVersionsMap.put(attachmentType, tvlist);
        }
        tvlist.add(tv);
    }

    public void removeAttachmentType(Class attachmentType) {
        log.debug((Object)("removeAttachmentType, " + attachmentType));
        this.attachmentToTypeMap.remove(attachmentType);
    }

    public void removeVersionedAttachmentType(Class attachmentType, String deploymentType) {
        log.debug((Object)("removeVersionedAttachmentType, " + attachmentType));
        List<TypeVersion> tvlist = this.attachmentToTypeVersionsMap.get(attachmentType);
        if (tvlist != null) {
            Iterator<TypeVersion> iter = tvlist.iterator();
            while (iter.hasNext()) {
                TypeVersion tv = iter.next();
                if (!deploymentType.equals(tv.type)) continue;
                iter.remove();
            }
            this.attachmentToTypeVersionsMap.put(attachmentType, tvlist);
            if (tvlist.size() == 0) {
                this.attachmentToTypeVersionsMap.remove(attachmentType);
            }
        }
    }

    private String getVersion(Object attachment, String getterName) {
        String version = null;
        try {
            Class[] parameterTypes = new Class[]{};
            Method getVersion = attachment.getClass().getMethod(getterName, parameterTypes);
            Object[] args = new Object[]{};
            version = (String)getVersion.invoke(attachment, args);
        }
        catch (Throwable t) {
            log.debug((Object)("Failed to get version:" + t));
        }
        return version;
    }

    private void addType(ManagedDeployment md, String type) {
        if (md.getTypes() == null) {
            md.setTypes(new HashSet());
        }
        md.addType(type);
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("3.*");
        Matcher m = p.matcher("3.0");
        System.out.println("3.0 matches: " + m.matches());
        m = p.matcher("3.1");
        System.out.println("3.1 matches: " + m.matches());
        m = p.matcher("3.x");
        System.out.println("3.x matches: " + m.matches());
        m = p.matcher("2.1");
        System.out.println("2.1 matches: " + m.matches());
        Pattern p2x = Pattern.compile("[1-2].*");
        m = p2x.matcher("3.1");
        System.out.println("3.1 is 2x: " + m.matches());
        m = p2x.matcher("1.1");
        System.out.println("1.1 is 2x: " + m.matches());
        m = p2x.matcher("2.1");
        System.out.println("2.1 is 2x: " + m.matches());
    }

    static class TypeVersion {
        private String type;
        private Pattern versionPattern;
        private String versionGetter;

        public TypeVersion(String type, Pattern versionPattern, String versionGetter) {
            this.type = type;
            this.versionPattern = versionPattern;
            this.versionGetter = versionGetter;
        }
    }
}

