/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.aop;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingAdvice {
    private static Logger log = Logger.getLogger(TrackingAdvice.class);
    private static ConcurrentHashMap<Object, Map<String, Object>> attachmentsByTarget = new ConcurrentHashMap();
    private static boolean trace = true;

    public static Attachments wrapAttachments(Attachments attachments) {
        return TrackingAdvice.createProxy(attachments, Attachments.class);
    }

    public Object invoke(Invocation inv) throws Throwable {
        if (trace) {
            log.trace((Object)("invoke, " + inv));
        }
        return inv.invokeNext();
    }

    public Object addAttachment(MethodInvocation mi) throws Throwable {
        Object attachment;
        String name;
        if (trace) {
            log.trace((Object)mi);
        }
        Object target = mi.getTargetObject();
        Object[] args = mi.getArguments();
        Object value = mi.invokeNext();
        if (args[0] instanceof Class) {
            Class c = (Class)Class.class.cast(args[0]);
            name = c.getName();
            attachment = args[1];
        } else {
            name = (String)String.class.cast(args[0]);
            attachment = args[1];
        }
        TrackingAdvice.addAttachment(target, name, attachment);
        return value;
    }

    public static Object removeAttachment(MethodInvocation mi) throws Throwable {
        String name;
        Object target = mi.getTargetObject();
        Object[] args = mi.getArguments();
        Object value = mi.invokeNext();
        if (args[0] instanceof Class) {
            Class c = (Class)Class.class.cast(args[0]);
            name = c.getName();
        } else {
            name = (String)String.class.cast(args[0]);
        }
        TrackingAdvice.removeAttachment(target, name);
        return value;
    }

    public static Map<String, Object> getAttachmentsForTarget(Object key) {
        Map<String, Object> attachments = attachmentsByTarget.get(key);
        return attachments;
    }

    public static Map<String, Object> clearAttachmentsForTarget(Object key) {
        Map<String, Object> attachments = attachmentsByTarget.remove(key);
        if (trace) {
            log.trace((Object)("clearAttachmentsForTarget, target=" + key + " :" + attachments));
        }
        return attachments;
    }

    private static void addAttachment(Object target, String name, Object attachment) {
        Map<String, Object> attachments = attachmentsByTarget.get(target);
        if (attachments == null) {
            attachments = new HashMap<String, Object>();
            attachmentsByTarget.put(target, attachments);
        }
        attachments.put(name, attachment);
        if (trace) {
            log.trace((Object)("addAttachment, target=" + target + ", name=" + name + ", attachment=" + attachment));
        }
    }

    private static void removeAttachment(Object target, String name) {
        Map<String, Object> attachments = attachmentsByTarget.get(target);
        if (attachments != null) {
            attachments.remove(name);
            if (attachments.size() == 0) {
                attachmentsByTarget.remove(target);
            }
        }
        if (trace) {
            log.trace((Object)("removeAttachment, target=" + target + ", name=" + name));
        }
    }

    public static <T> T createProxy(T target, Class<T> interfaceClass) {
        if (target == null) {
            return null;
        }
        GeneratedAOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setInterfaces(new Class[]{interfaceClass});
        params.setObjectAsSuperClass(true);
        params.setTarget(target);
        Object proxy = proxyFactory.createAdvisedProxy(params);
        if (trace) {
            log.trace((Object)("Created proxy: " + proxy.getClass() + "@" + System.identityHashCode(proxy) + " target: " + target.getClass()));
        }
        return interfaceClass.cast(proxy);
    }
}

