/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.SyncFailedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.AttachmentsSerializer;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.util.file.Files;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableDeploymentRepository
implements DeploymentRepository {
    private static final Logger log = Logger.getLogger(SerializableDeploymentRepository.class);
    private File root;
    private File bootstrapDir;
    private File libDir;
    private File deployersDir;
    private File[] applicationDirs;
    private final Map<String, VirtualFile> applicationVFCache = new HashMap<String, VirtualFile>();
    private File adminEditsRoot;
    private ProfileKey key;
    private LinkedHashMap<String, VFSDeployment> bootstrapCtxs = new LinkedHashMap();
    private LinkedHashMap<String, VFSDeployment> deployerCtxs = new LinkedHashMap();
    private LinkedHashMap<String, VFSDeployment> applicationCtxs = new LinkedHashMap();
    private AttachmentsSerializer serializer;
    private Map<String, Integer> contentFlags = new ConcurrentHashMap<String, Integer>();
    private long lastModified;
    private ReentrantReadWriteLock contentLock = new ReentrantReadWriteLock(true);
    private boolean failIfAlreadyExists = false;

    public SerializableDeploymentRepository(File root, URI[] appURIs, ProfileKey key) {
        this.root = root;
        this.key = key;
        this.setApplicationURIs(appURIs);
    }

    public AttachmentsSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(AttachmentsSerializer serializer) {
        this.serializer = serializer;
    }

    public URI[] getApplicationURIs() {
        URI[] appURIs = new URI[this.applicationDirs.length];
        for (int n = 0; n < this.applicationDirs.length; ++n) {
            File applicationDir = this.applicationDirs[n];
            appURIs[n] = applicationDir.toURI();
        }
        return appURIs;
    }

    public void setApplicationURIs(URI[] uris) {
        this.applicationDirs = new File[uris.length];
        for (int n = 0; n < uris.length; ++n) {
            URI uri = uris[n];
            this.applicationDirs[n] = new File(uri);
        }
    }

    public boolean exists() {
        File profileRoot = new File(this.root, this.key.getName());
        return profileRoot.exists();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public URI getDeploymentURI(ManagedDeployment.DeploymentPhase phase) {
        URI uri = null;
        switch (phase) {
            case BOOTSTRAP: {
                uri = this.getBootstrapURI();
                break;
            }
            case DEPLOYER: {
                uri = this.getDeployersURI();
                break;
            }
            case APPLICATION: {
                uri = this.getApplicationURI();
            }
        }
        return uri;
    }

    @Override
    public void setDeploymentURI(URI uri, ManagedDeployment.DeploymentPhase phase) {
        switch (phase) {
            case BOOTSTRAP: {
                this.setBootstrapURI(uri);
                break;
            }
            case DEPLOYER: {
                this.setDeployersURI(uri);
                break;
            }
            case APPLICATION: {
                this.setApplicationURIs(new URI[]{uri});
            }
        }
    }

    @Override
    public Set<String> getDeploymentNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.bootstrapCtxs.keySet());
        names.addAll(this.deployerCtxs.keySet());
        names.addAll(this.applicationCtxs.keySet());
        return names;
    }

    @Override
    public Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase phase) {
        HashSet<String> names = new HashSet<String>();
        switch (phase) {
            case BOOTSTRAP: {
                names.addAll(this.bootstrapCtxs.keySet());
                break;
            }
            case DEPLOYER: {
                names.addAll(this.deployerCtxs.keySet());
                break;
            }
            case APPLICATION: {
                names.addAll(this.applicationCtxs.keySet());
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addDeploymentContent(String name, InputStream contentIS, ManagedDeployment.DeploymentPhase phase) throws IOException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Aquiring content read lock");
        }
        this.contentLock.writeLock().lock();
        String repositoryName = null;
        try {
            File contentRoot = this.getPhaseDir(phase);
            if (contentRoot == null) {
                throw new FileNotFoundException("Failed to obtain content dir for phase: " + phase);
            }
            File contentFile = new File(contentRoot, name);
            if (this.failIfAlreadyExists && contentFile.exists()) {
                throw new SyncFailedException("Deployment content already exists: " + contentFile.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(contentFile);
            try {
                int read;
                byte[] tmp = new byte[4096];
                while ((read = contentIS.read(tmp)) > 0) {
                    if (trace) {
                        log.trace((Object)("write, " + read));
                    }
                    fos.write(tmp, 0, read);
                }
                fos.flush();
                VirtualFile contentVF = VFS.getVirtualFile((URI)contentRoot.toURI(), (String)name);
                repositoryName = contentVF.getName();
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
            this.lockDeploymentContent(name, phase);
        }
        finally {
            this.contentLock.writeLock().unlock();
            if (trace) {
                log.trace((Object)"Released content write lock");
            }
        }
        return repositoryName;
    }

    @Override
    public VirtualFile getDeploymentContent(String name, ManagedDeployment.DeploymentPhase phase) throws IOException, URISyntaxException {
        switch (phase) {
            case BOOTSTRAP: 
            case DEPLOYER: {
                throw new IOException(phase + " content access not supported");
            }
        }
        File contentRoot = this.getPhaseDir(phase);
        if (contentRoot == null) {
            throw new FileNotFoundException("Failed to obtain content dir for phase: " + phase);
        }
        File contentFile = new File(contentRoot, name);
        VirtualFile content = this.getCachedApplicationVF(contentFile);
        if (content == null || !content.exists()) {
            throw new FileNotFoundException("Failed to find content for: " + name);
        }
        return content;
    }

    @Override
    public String[] getRepositoryNames(String[] names, ManagedDeployment.DeploymentPhase phase) throws IOException {
        ArrayList<String> tmp = new ArrayList<String>();
        URI rootURI = this.getDeploymentURI(phase);
        VirtualFile root = VFS.getRoot((URI)rootURI);
        for (String name : names) {
            VirtualFile content = root.getChild(name);
            try {
                String rname = content.toURI().toString();
                tmp.add(rname);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Should not happen", (Throwable)e);
            }
        }
        String[] rnames = new String[tmp.size()];
        tmp.toArray(rnames);
        return rnames;
    }

    @Override
    public int lockDeploymentContent(String vfsPath, ManagedDeployment.DeploymentPhase phase) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("lockDeploymentContent, " + vfsPath));
        }
        int flags = this.setDeploymentContentFlags(vfsPath, phase, 4);
        return flags;
    }

    @Override
    public int unlockDeploymentContent(String vfsPath, ManagedDeployment.DeploymentPhase phase) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("unlockDeploymentContent, " + vfsPath));
        }
        int flags = this.clearDeploymentContentFlags(vfsPath, phase, 4);
        return flags;
    }

    @Override
    public int getDeploymentContentFlags(String vfsPath, ManagedDeployment.DeploymentPhase phase) {
        Integer flags = this.contentFlags.get(vfsPath);
        int iflags = flags != null ? flags : 0;
        return iflags;
    }

    @Override
    public synchronized int clearDeploymentContentFlags(String vfsPath, ManagedDeployment.DeploymentPhase phase, int flags) {
        Integer dflags = this.contentFlags.get(vfsPath);
        if (dflags != null) {
            dflags = dflags & ~flags;
            this.contentFlags.put(vfsPath, dflags);
        }
        int iflags = dflags != null ? dflags : 0;
        return iflags;
    }

    @Override
    public boolean hasDeploymentContentFlags(String vfsPath, ManagedDeployment.DeploymentPhase phase, int flag) {
        Integer flags = this.contentFlags.get(vfsPath);
        boolean hasFlag = false;
        if (flags != null) {
            hasFlag = (flags & flag) != 0;
        }
        return hasFlag;
    }

    @Override
    public int setDeploymentContentFlags(String vfsPath, ManagedDeployment.DeploymentPhase phase, int flags) {
        this.contentFlags.put(vfsPath, flags);
        return flags;
    }

    @Override
    public void acquireDeploymentContentLock() {
        this.contentLock.writeLock().lock();
        if (log.isTraceEnabled()) {
            log.trace((Object)"acquireDeploymentContentLock, have write lock");
        }
    }

    @Override
    public void releaseDeploymentContentLock() {
        this.contentLock.writeLock().unlock();
        if (log.isTraceEnabled()) {
            log.trace((Object)"releaseDeploymentContentLock, gave up write lock");
        }
    }

    @Override
    public void addDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
        switch (phase) {
            case BOOTSTRAP: {
                this.addBootstrap(vfsPath, d);
                break;
            }
            case DEPLOYER: {
                this.addDeployer(vfsPath, d);
                break;
            }
            case APPLICATION: {
                this.addApplication(vfsPath, d);
                break;
            }
            case APPLICATION_TRANSIENT: {
                this.addApplication(vfsPath, d);
            }
        }
    }

    @Override
    public void updateDeployment(String vfsPath, VFSDeployment d, ManagedDeployment.DeploymentPhase phase) throws Exception {
    }

    @Override
    public VFSDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception, NoSuchDeploymentException {
        VFSDeployment ctx = null;
        if (phase == null) {
            try {
                ctx = this.getBootstrap(name);
            }
            catch (NoSuchDeploymentException ignore) {
                // empty catch block
            }
            try {
                if (ctx == null) {
                    ctx = this.getDeployer(name);
                }
            }
            catch (NoSuchDeploymentException ignore) {
                // empty catch block
            }
            try {
                if (ctx == null) {
                    ctx = this.getApplication(name);
                }
            }
            catch (NoSuchDeploymentException ignore) {}
        } else {
            switch (phase) {
                case BOOTSTRAP: {
                    ctx = this.getBootstrap(name);
                    break;
                }
                case DEPLOYER: {
                    ctx = this.getDeployer(name);
                    break;
                }
                case APPLICATION: {
                    ctx = this.getApplication(name);
                }
            }
        }
        if (ctx == null) {
            throw new NoSuchDeploymentException("name=" + name + ", phase=" + phase);
        }
        return ctx;
    }

    @Override
    public Collection<VFSDeployment> getDeployments() {
        HashSet<VFSDeployment> deployments = new HashSet<VFSDeployment>();
        deployments.addAll(this.bootstrapCtxs.values());
        deployments.addAll(this.deployerCtxs.values());
        deployments.addAll(this.applicationCtxs.values());
        return Collections.unmodifiableCollection(deployments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        ArrayList<ModificationInfo> modified = new ArrayList<ModificationInfo>();
        Collection<VFSDeployment> apps = this.getApplications();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Checking applications for modifications");
        }
        if (trace) {
            log.trace((Object)"Aquiring content read lock");
        }
        this.contentLock.readLock().lock();
        try {
            if (apps != null) {
                Iterator<VFSDeployment> iter = apps.iterator();
                while (iter.hasNext()) {
                    long rootLastModified;
                    int flags;
                    VFSDeployment ctx = iter.next();
                    VirtualFile root = ctx.getRoot();
                    String name = root.getPathName();
                    if (this.hasDeploymentContentFlags(name, ManagedDeployment.DeploymentPhase.APPLICATION, flags = 5)) {
                        if (!trace) continue;
                        log.trace((Object)("Ignoring locked application: " + root));
                        continue;
                    }
                    if (!root.exists()) {
                        rootLastModified = root.getLastModified();
                        ModificationInfo info = new ModificationInfo(ctx, rootLastModified, ModificationInfo.ModifyStatus.REMOVED);
                        modified.add(info);
                        iter.remove();
                        if (!trace) continue;
                        log.trace((Object)(name + " was removed"));
                        continue;
                    }
                    if (!root.hasBeenModified() && !this.hasDeploymentContentFlags(root.getPathName(), ManagedDeployment.DeploymentPhase.APPLICATION, 8)) continue;
                    rootLastModified = root.getLastModified();
                    if (trace) {
                        log.trace((Object)(name + " was modified: " + rootLastModified));
                    }
                    VFSDeployment ctx2 = this.loadDeploymentData(root);
                    ModificationInfo info = new ModificationInfo(ctx2, rootLastModified, ModificationInfo.ModifyStatus.MODIFIED);
                    modified.add(info);
                }
                for (File applicationDir : this.applicationDirs) {
                    VirtualFile deployDir = this.getCachedApplicationVF(applicationDir);
                    List children = deployDir.getChildren();
                    for (VirtualFile vf : children) {
                        String key = vf.toURI().toString();
                        if (this.applicationCtxs.containsKey(key)) continue;
                        VFSDeployment ctx = this.loadDeploymentData(vf);
                        ModificationInfo info = new ModificationInfo(ctx, vf.getLastModified(), ModificationInfo.ModifyStatus.ADDED);
                        modified.add(info);
                        if (key.startsWith("test")) {
                            log.error((Object)"Should not see a test... key");
                        }
                        this.applicationCtxs.put(key, ctx);
                    }
                }
            }
        }
        finally {
            this.contentLock.readLock().unlock();
            if (trace) {
                log.trace((Object)"Released content read lock");
            }
        }
        if (modified.size() > 0) {
            this.lastModified = System.currentTimeMillis();
        }
        return modified;
    }

    @Override
    public Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase phase) throws Exception {
        Collection<VFSDeployment> ctxs = null;
        switch (phase) {
            case BOOTSTRAP: {
                ctxs = this.getBootstraps();
                break;
            }
            case DEPLOYER: {
                ctxs = this.getDeployers();
                break;
            }
            case APPLICATION: {
                ctxs = this.getApplications();
            }
        }
        return ctxs;
    }

    @Override
    public VFSDeployment removeDeployment(String name, ManagedDeployment.DeploymentPhase phase) throws Exception {
        VFSDeployment ctx = null;
        switch (phase) {
            case BOOTSTRAP: {
                ctx = this.removeBootstrap(name);
                break;
            }
            case DEPLOYER: {
                ctx = this.removeDeployer(name);
                break;
            }
            case APPLICATION: {
                ctx = this.removeApplication(name);
            }
        }
        return ctx;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append("(root=");
        tmp.append(this.root);
        tmp.append(", key=");
        tmp.append(this.key);
        tmp.append(")");
        return tmp.toString();
    }

    @Override
    public void create() throws Exception {
        File profileRoot = new File(this.root, this.key.getName());
        if (profileRoot.exists()) {
            throw new IOException("Profile root already exists: " + profileRoot);
        }
        if (!profileRoot.mkdirs()) {
            throw new IOException("Failed to create profile root: " + profileRoot);
        }
        this.bootstrapDir = new File(profileRoot, "bootstrap");
        if (!this.bootstrapDir.mkdirs()) {
            throw new IOException("Failed to create profile bootstrap dir: " + this.bootstrapDir);
        }
        this.deployersDir = new File(profileRoot, "deployers");
        if (!this.deployersDir.mkdirs()) {
            throw new IOException("Failed to create profile deployers dir: " + this.deployersDir);
        }
        for (File applicationDir : this.applicationDirs) {
            if (applicationDir.mkdirs()) continue;
            throw new IOException("Failed to create profile deploy dir: " + applicationDir);
        }
        this.libDir = new File(profileRoot, "lib");
        if (!this.libDir.mkdirs()) {
            throw new IOException("Failed to create profile lib dir: " + this.libDir);
        }
        this.adminEditsRoot = new File(profileRoot, "profile/edits");
        if (!this.adminEditsRoot.mkdirs()) {
            throw new IOException("Failed to create profile adminEdits dir: " + this.adminEditsRoot);
        }
    }

    @Override
    public void load() throws Exception, NoSuchProfileException {
        if (this.serializer == null) {
            throw new IllegalStateException("serializer has not been set");
        }
        File profileRoot = new File(this.root, this.key.getName());
        if (!profileRoot.exists()) {
            throw new NoSuchProfileException("Profile root does not exists: " + profileRoot);
        }
        this.bootstrapDir = new File(profileRoot, "bootstrap");
        if (!this.bootstrapDir.exists()) {
            this.bootstrapDir = null;
        }
        this.deployersDir = new File(profileRoot, "deployers");
        if (!this.deployersDir.exists()) {
            throw new FileNotFoundException("Profile contains no deployers dir: " + this.deployersDir);
        }
        for (File applicationDir : this.applicationDirs) {
            if (applicationDir.exists()) continue;
            throw new FileNotFoundException("Profile contains no deploy dir: " + applicationDir);
        }
        this.adminEditsRoot = new File(profileRoot, "profile/edits");
        if (this.bootstrapDir != null) {
            VFS bootstrapVFS = VFS.getVFS((URI)this.bootstrapDir.toURI());
            this.loadBootstraps(bootstrapVFS.getRoot());
        } else {
            this.loadBootstraps(null);
        }
        VFS deployersVFS = VFS.getVFS((URI)this.deployersDir.toURI());
        this.loadDeployers(deployersVFS.getRoot());
        for (File applicationDir : this.applicationDirs) {
            VirtualFile dirVF = this.getCachedApplicationVF(applicationDir);
            this.loadApplications(dirVF);
        }
        this.lastModified = System.currentTimeMillis();
    }

    protected VirtualFile getCachedApplicationVF(File applicationDir) throws IOException {
        URI uri = applicationDir.toURI();
        return this.getCachedApplicationVF(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualFile getCachedApplicationVF(URI uri) throws IOException {
        VirtualFile dir;
        String uriString = uri.toString();
        Map<String, VirtualFile> map = this.applicationVFCache;
        synchronized (map) {
            dir = this.applicationVFCache.get(uriString);
            if (dir == null) {
                dir = VFS.getRoot((URI)uri);
                this.applicationVFCache.put(uriString, dir);
            }
        }
        return dir;
    }

    @Override
    public void remove() throws IOException, NoSuchProfileException {
        File profileRoot = new File(this.root, this.key.getName());
        Files.delete((File)profileRoot);
    }

    protected void addBootstrap(String vfsPath, VFSDeployment ctx) throws Exception {
        this.bootstrapCtxs.put(vfsPath, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addManagedObject(String vfsPath, Attachments edits) throws IOException {
        Map map = edits.getAttachments();
        File attachments = new File(this.adminEditsRoot, vfsPath + ".edits");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(attachments));
        try {
            oos.writeObject(map);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException ignore) {}
        }
        this.lastModified = System.currentTimeMillis();
    }

    protected void addDeployer(String vfsPath, VFSDeployment ctx) throws Exception {
        this.deployerCtxs.put(vfsPath, ctx);
    }

    protected void addApplication(String vfsPath, VFSDeployment ctx) throws Exception {
        if (vfsPath.startsWith("test")) {
            log.error((Object)"Should not see a test... key");
        }
        log.info((Object)("Adding application: " + vfsPath + " / " + ctx));
        this.applicationCtxs.put(vfsPath, ctx);
    }

    protected VFSDeployment getBootstrap(String vfsPath) throws Exception {
        VFSDeployment ctx = this.bootstrapCtxs.get(vfsPath);
        if (ctx == null) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        return ctx;
    }

    protected Collection<VFSDeployment> getBootstraps() throws Exception {
        return this.bootstrapCtxs.values();
    }

    protected File getPhaseDir(ManagedDeployment.DeploymentPhase phase) {
        File dir = null;
        switch (phase) {
            case BOOTSTRAP: {
                dir = this.bootstrapDir;
                break;
            }
            case DEPLOYER: {
                dir = this.deployersDir;
                break;
            }
            case APPLICATION: {
                dir = this.applicationDirs[0];
                break;
            }
        }
        return dir;
    }

    protected URI getBootstrapURI() {
        return this.bootstrapDir.toURI();
    }

    protected URI getDeployersURI() {
        return this.deployersDir.toURI();
    }

    protected URI getApplicationURI() {
        File applicationDir = this.applicationDirs[0];
        return applicationDir.toURI();
    }

    protected VFSDeployment getDeployer(String vfsPath) throws Exception {
        VFSDeployment ctx = this.deployerCtxs.get(vfsPath);
        if (ctx == null) {
            throw new NoSuchDeploymentException(vfsPath);
        }
        return ctx;
    }

    protected Collection<VFSDeployment> getDeployers() throws Exception {
        return this.deployerCtxs.values();
    }

    protected VFSDeployment getApplication(String vfsPath) throws Exception {
        VFSDeployment ctx = this.applicationCtxs.get(vfsPath);
        if (ctx == null) {
            log.info((Object)("Failed to find application for: " + vfsPath + ", scanning for simple name"));
            for (VFSDeployment deployment : this.applicationCtxs.values()) {
                log.debug((Object)("Checking: " + deployment.getSimpleName()));
                if (!deployment.getSimpleName().equals(vfsPath)) continue;
                log.debug((Object)("Matched to simple name of deployment:" + deployment));
                ctx = deployment;
                break;
            }
            if (ctx == null) {
                log.debug((Object)("Failed to find application for: " + vfsPath + ", available: " + this.applicationCtxs.values()));
                throw new NoSuchDeploymentException(vfsPath);
            }
        }
        return ctx;
    }

    protected Collection<VFSDeployment> getApplications() throws Exception {
        return this.applicationCtxs.values();
    }

    protected VFSDeployment removeBootstrap(String vfsPath) throws IOException {
        VFSDeployment vfsDeployment = this.bootstrapCtxs.get(vfsPath);
        if (vfsDeployment == null) {
            throw new IllegalStateException("Deployment not found: " + vfsPath + ", available: " + this.bootstrapCtxs.values());
        }
        VirtualFile root = vfsDeployment.getRoot();
        if (!root.delete()) {
            throw new IOException("Failed to delete: " + root);
        }
        return (VFSDeployment)this.bootstrapCtxs.remove(vfsPath);
    }

    protected VFSDeployment removeDeployer(String vfsPath) throws IOException {
        VFSDeployment vfsDeployment = this.deployerCtxs.get(vfsPath);
        if (vfsDeployment == null) {
            throw new IllegalStateException("Deployment not found: " + vfsPath + ", available: " + this.deployerCtxs.values());
        }
        VirtualFile root = vfsDeployment.getRoot();
        if (!root.delete()) {
            throw new IOException("Failed to delete: " + root);
        }
        return (VFSDeployment)this.deployerCtxs.remove(vfsPath);
    }

    protected VFSDeployment removeApplication(String vfsPath) throws Exception {
        VFSDeployment vfsDeployment = this.getApplication(vfsPath);
        VirtualFile root = vfsDeployment.getRoot();
        if (!root.delete()) {
            throw new IOException("Failed to delete: " + root);
        }
        return (VFSDeployment)this.applicationCtxs.remove(vfsPath);
    }

    protected void setBootstrapURI(URI uri) {
        this.bootstrapDir = new File(uri);
    }

    protected void setDeployersURI(URI uri) {
        this.deployersDir = new File(uri);
    }

    private void loadBootstraps(VirtualFile bootstrapDir) throws IOException {
        if (bootstrapDir != null) {
            List children = bootstrapDir.getChildren();
            for (VirtualFile vf : children) {
                VFSDeployment vfCtx = this.loadDeploymentData(vf);
                this.bootstrapCtxs.put(vf.getName(), vfCtx);
            }
        } else {
            File profileRoot = new File(this.root, this.key.getName());
            File confDir = new File(profileRoot, "conf");
            VirtualFile confVF = VFS.getRoot((URI)confDir.toURI());
            VirtualFile jbossServiceVF = confVF.getChild("jboss-service.xml");
            if (jbossServiceVF == null) {
                throw new FileNotFoundException("Failed to find jboss-service.xml under conf");
            }
            VFSDeployment vfCtx = this.loadDeploymentData(jbossServiceVF);
            this.bootstrapCtxs.put(vfCtx.getName(), vfCtx);
        }
    }

    private void loadDeployers(VirtualFile deployersDir) throws IOException {
        List children = deployersDir.getChildren();
        for (VirtualFile vf : children) {
            VFSDeployment vfCtx = this.loadDeploymentData(vf);
            this.deployerCtxs.put(vfCtx.getName(), vfCtx);
        }
    }

    private void loadApplications(VirtualFile applicationDir) throws IOException {
        List children = applicationDir.getChildren();
        for (VirtualFile vf : children) {
            VFSDeployment vfCtx = this.loadDeploymentData(vf);
            String key = vfCtx.getName();
            this.applicationCtxs.put(key, vfCtx);
        }
    }

    private VFSDeployment loadDeploymentData(VirtualFile file) {
        VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(file);
        log.debug((Object)("Created deployment: " + deployment));
        return deployment;
    }
}

