/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice;

import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.profileservice.spi.Profile;
import org.jboss.virtual.VirtualFile;
import org.jboss.managed.api.ManagedDeployment;

/**
 * DeploymentPhaseScanner.
 *
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 */
public abstract class DeploymentPhaseVFSScanner extends VFSScanner
{
   private ManagedDeployment.DeploymentPhase phase;

   protected DeploymentPhaseVFSScanner(ManagedDeployment.DeploymentPhase phase)
   {
      if (phase == null)
         throw new IllegalArgumentException("Null deployment phase");
      this.phase = phase;
   }

   protected VFSDeployment add(Profile profile, VirtualFile file) throws Exception
   {
      VFSDeployment deployment = createDeployment(file);
      if(profile.hasDeployment(deployment.getName(), phase) == false)
         profile.addDeployment(deployment, phase);
      return deployment;
   }

   protected void remove(Profile profile, String name) throws Exception
   {
      profile.removeDeployment(name, phase);
   }
}
