/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

/**
 * A basic JAXB attachment Serializer.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class JAXBAttachmentSerializer extends AbstractFileAttachmentsSerializer
{
   
   /** The logger */
   private static final Logger log = Logger.getLogger(JAXBAttachmentSerializer.class);
   
   /** The QNAME for the root element */
   private static final QName ROOT_NAME = new QName("attachment");
   
   /** The attachment suffix. */
   private static final String ATTACHMENT_SUFFIX = ".attachment.xml";
   
   @SuppressWarnings("unchecked")
   protected <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws Exception
   {
      JAXBContext ctx = JAXBContext.newInstance(expected);
      Unmarshaller unmarshaller = ctx.createUnmarshaller();
      // FIXME this is a hack
      if(PersistedManagedObject.class.getName().equals(expected.getName()))
      {
         hack(unmarshaller);
      }
      return (T) unmarshaller.unmarshal(attachmentsStore);
   }

   protected void saveAttachment(File attachmentsStore, Object attachment) throws Exception
   {
      log.trace("saveAttachments, attachmentsStore="+attachmentsStore+ ", attachment="+attachment);
      JAXBContext ctx = JAXBContext.newInstance(attachment.getClass());
      Marshaller marshaller = ctx.createMarshaller();
      marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
      marshaller.marshal(attachment, attachmentsStore);
   }
   
   protected static <T> JAXBElement<T> createRootElement(Class<T> expected, Object o)
   {
      return new JAXBElement<T>(ROOT_NAME, expected, (T) o);
   }
   
   @Override
   protected File getAttachmentPath(String baseName)
   {
      final String vfsPath = baseName + ATTACHMENT_SUFFIX;
      return new File(getAttachmentsStoreDir(), vfsPath);
   }
   
   private void hack(Unmarshaller unmarshaller)
   {
      unmarshaller.setListener(new PeristedManagedObjectHandler());
   }
   
   /**
    * Hack handler for JAXB.
    */
   private static class PeristedManagedObjectHandler extends Unmarshaller.Listener
   {
      @Override
      public void afterUnmarshal(Object target, Object parent)
      {
         if(parent instanceof PersistedManagedObject)
         {
            if(target instanceof PersistedProperty)
            {
               PersistedProperty p = (PersistedProperty) target;
               ((PersistedManagedObject) parent).put(p.getName(), p);
            }
         }
         else if(parent instanceof PersistedCompositeValue)
         {
            if(target instanceof PersistedValue)
            {
               PersistedValue v = (PersistedValue) target;
               ((PersistedCompositeValue) parent).put(v.getName(), v);
            }
         }
      }
   }
   
}
