/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;

import org.jboss.logging.Logger;

/**
 * Standard java serialization to a file.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class JavaSerializationAttachmentsSerializer
   extends AbstractFileAttachmentsSerializer
{
   private static final Logger log = Logger.getLogger(JavaSerializationAttachmentsSerializer.class);
   
   @Override
   @SuppressWarnings("unchecked")
   protected <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws Exception
   {
      FileInputStream fis = new FileInputStream(attachmentsStore);
      ObjectInputStream ois = new ObjectInputStream(fis);
      T object = null;
      try
      {
         object = (T) ois.readObject();
      }
      catch(ClassNotFoundException e)
      {
         URL[] path = getClassLoaderURLs(Thread.currentThread().getContextClassLoader());
         log.debug("ClassNotFoundException: "+e.getMessage()+", path: "+Arrays.asList(path));
      }
      finally
      {
         try
         {
            ois.close();
         }
         catch(Exception igore)
         {            
         }
         try
         {
            fis.close();
         }
         catch(Exception igore)
         {            
         }
      }
      return object;
   }

   @Override
   protected void saveAttachment(File attachmentsStore, Object attachment) throws Exception
   {
      log.trace("saveAttachments, attachmentsStore="+attachmentsStore+ ", attachment="+attachment);
      FileOutputStream fos = new FileOutputStream(attachmentsStore);
      ObjectOutputStream oos = new ObjectOutputStream(fos);
      try
      {
         oos.writeObject(attachment);
      }
      finally
      {
         try
         {
            oos.close();
         }
         catch(Exception igore)
         {            
         }
         try
         {
            fos.close();
         }
         catch(Exception igore)
         {            
         }
      }
   }

   /** Use reflection to access a URL[] getURLs or URL[] getClasspath method so
   that non-URLClassLoader class loaders, or class loaders that override
   getURLs to return null or empty, can provide the true classpath info.
   */
   @SuppressWarnings("unchecked")
  private static URL[] getClassLoaderURLs(ClassLoader cl)
  {
     URL[] urls = {};
     try
     {
        Class returnType = urls.getClass();
        Class[] parameterTypes = {};
        Class clClass = cl.getClass();
        Method getURLs = clClass.getMethod("getURLs", parameterTypes);
        if( returnType.isAssignableFrom(getURLs.getReturnType()) )
        {
           Object[] args = {};
           urls = (URL[]) getURLs.invoke(cl, args);
        }
     }
     catch(Exception ignore)
     {
     }
     if( urls == null || urls.length == 0 )
     {
        try
        {
           Class returnType = urls.getClass();
           Class[] parameterTypes = {};
           Class clClass = cl.getClass();
           Method getURLs = clClass.getMethod("getAllURLs", parameterTypes);
           if( returnType.isAssignableFrom(getURLs.getReturnType()) )
           {
              Object[] args = {};
              urls = (URL[]) getURLs.invoke(cl, args);
           }
        }
        catch(Exception ignore)
        {
        }
     }
     if( urls == null || urls.length == 0 )
     {
        try
        {
           Class returnType = urls.getClass();
           Class[] parameterTypes = {};
           Class clClass = cl.getClass();
           Method getURLs = clClass.getMethod("getClasspath", parameterTypes);
           if( returnType.isAssignableFrom(getURLs.getReturnType()) )
           {
              Object[] args = {};
              urls = (URL[]) getURLs.invoke(cl, args);
           }
        }
        catch(Exception ignore)
        {
        }
     }
     
     return urls;
  }

}
