/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.Name;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.api.values.TableValueSupport;
import org.jboss.metatype.plugins.types.StringName;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.system.server.profileservice.persistence.xml.PersistedArrayValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCollectionValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedCompositeValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedEnumValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedSimpleValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

public class ManagedObjectUpdateHandler {
    ManagedObjectFactory managedObjectFactory = ManagedObjectFactory.getInstance();
    MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final Map<String, Class<? extends Serializable>> simpleTypes = new HashMap<String, Class<? extends Serializable>>();
    private static final Logger log = Logger.getLogger(ManagedObjectUpdateHandler.class);

    public Object processManagedObject(PersistedManagedObject moElement, ManagedObject mo) {
        if (moElement == null) {
            throw new IllegalArgumentException("Null rootElement.");
        }
        if (mo == null) {
            throw new IllegalArgumentException("null managedObject");
        }
        Object attachment = mo.getAttachment();
        Set<String> propertyNames = moElement.keySet();
        for (String propertyName : propertyNames) {
            ManagedProperty property = mo.getProperty(propertyName);
            if (property == null) {
                throw new IllegalStateException("unable to find propery: " + property);
            }
            if (property.hasViewUse(ViewUse.STATISTIC)) continue;
            PersistedProperty propertyElement = (PersistedProperty)moElement.get(propertyName);
            this.processManagedProperty(propertyElement, propertyName, property, attachment);
        }
        return attachment;
    }

    protected void processManagedProperty(PersistedProperty propertyElement, String name, ManagedProperty property, Object attachment) {
        boolean trace = log.isTraceEnabled();
        PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (propertyInfo != null && !propertyInfo.isReadable()) {
            if (trace) {
                log.trace((Object)("property " + name + "is not readable"));
            }
            return;
        }
        MetaValue value = property.getValue();
        if (value == null) {
            value = this.createEmptyMetaValue(property.getMetaType());
        }
        PersistedValue persistedValue = propertyElement.getValue();
        if (value != null && persistedValue != null) {
            MetaValue merged = this.processMetaValue(persistedValue, value);
            if (merged != null) {
                if (propertyInfo == null) {
                    return;
                }
                if (!propertyInfo.isWritable()) {
                    if (trace) {
                        log.trace((Object)("property " + name + "is not writable"));
                    }
                    return;
                }
                MetaType metaType = merged.getMetaType();
                if (!(metaType.isCollection() || metaType.isArray() || metaType.isTable())) {
                    try {
                        Object unwrapped;
                        property.setField("value", (Serializable)merged);
                        if (metaType.isComposite() && Proxy.isProxyClass((unwrapped = this.metaValueFactory.unwrap(merged, propertyInfo.getType())).getClass())) {
                            return;
                        }
                        InstanceClassFactory icf = this.managedObjectFactory.getInstanceClassFactory(attachment.getClass(), null);
                        BeanInfo beanInfo = propertyInfo.getBeanInfo();
                        icf.setValue(beanInfo, property, attachment, merged);
                    }
                    catch (Throwable t) {
                        log.debug((Object)("failed to set value to property: " + propertyInfo), t);
                    }
                }
            }
        } else {
            return;
        }
    }

    protected MetaValue processMetaValue(PersistedValue valueElement, MetaValue value) {
        MetaType metaType = value.getMetaType();
        SimpleValue metaValue = null;
        if (metaType.isSimple()) {
            metaValue = this.processSimpleValue((PersistedSimpleValue)valueElement, (SimpleValue)value);
        } else if (metaType.isEnum()) {
            metaValue = this.processEnumValue((PersistedEnumValue)valueElement, (EnumValue)value);
        } else if (metaType.isCollection()) {
            metaValue = this.processCollectionValue((PersistedCollectionValue)valueElement, (CollectionValue)value);
        } else if (metaType.isGeneric()) {
            metaValue = this.processGenericValue((PersistedGenericValue)valueElement, (GenericValue)value);
        } else if (metaType.isComposite()) {
            metaValue = this.processCompositeValue((PersistedCompositeValue)valueElement, (CompositeValue)value);
        } else if (!metaType.isTable()) {
            if (metaType.isArray()) {
                metaValue = this.processArrayValue((PersistedArrayValue)valueElement, (ArrayValue)value);
            } else {
                throw new IllegalStateException("unknown metaType");
            }
        }
        return metaValue;
    }

    protected EnumValue processEnumValue(PersistedEnumValue enumElement, EnumValue value) {
        return new EnumValueSupport(value.getMetaType(), enumElement.getValue());
    }

    protected CollectionValue processCollectionValue(PersistedCollectionValue collection, CollectionValue value) {
        if (collection.size() == 0) {
            return value;
        }
        if (collection.size() != value.getSize()) {
            log.warn((Object)("unable to merge collection: " + value));
            return value;
        }
        ArrayList<MetaValue> elementList = new ArrayList<MetaValue>();
        Iterator<PersistedValue> i = collection.getValues().iterator();
        for (MetaValue item : value) {
            MetaValue newValue = this.processMetaValue(i.next(), item);
            if (newValue == null) continue;
            MetaType metaType = newValue.getMetaType();
            if (metaType.isGeneric()) {
                ManagedObject mo = (ManagedObject)((GenericValue)newValue).getValue();
                if (mo == null) continue;
                newValue = new GenericValueSupport(new GenericMetaType(mo.getAttachmentName(), "mo"), (Serializable)((Object)mo.getAttachmentName()));
            }
            elementList.add(newValue);
        }
        return new CollectionValueSupport(value.getMetaType(), elementList.toArray(new MetaValue[elementList.size()]));
    }

    protected MetaValue processGenericValue(PersistedGenericValue genericElement, GenericValue value) {
        PersistedManagedObject po = genericElement.getManagedObject();
        if (po == null || value.getValue() == null) {
            return value;
        }
        if (value.getValue() instanceof ManagedObject) {
            ManagedObject mo = (ManagedObject)value.getValue();
            this.processManagedObject(po, mo);
            return value;
        }
        throw new IllegalStateException("The value of GenericValue must be a ManagedObject: " + value);
    }

    protected CompositeValue processCompositeValue(PersistedCompositeValue composite, CompositeValue value) {
        CompositeMetaType metaType = value.getMetaType();
        HashMap<String, MetaValue> values = new HashMap<String, MetaValue>();
        for (String key : composite.keySet()) {
            MetaValue metaValue = value.get(key);
            if (metaValue == null) {
                metaValue = this.createEmptyMetaValue(metaType.getType(key));
            }
            PersistedValue persistedValue = (PersistedValue)composite.get(key);
            metaValue = this.processMetaValue(persistedValue, metaValue);
            values.put(key, metaValue);
        }
        return new CompositeValueSupport(metaType, values);
    }

    protected ArrayValue processArrayValue(PersistedArrayValue array, ArrayValue value) {
        if (array.size() != value.getLength()) {
            log.debug((Object)("cannot merge array: " + value));
            return null;
        }
        ArrayList<MetaValue> arrayList = new ArrayList<MetaValue>();
        for (int i = 0; i < value.getLength(); ++i) {
            PersistedValue persisted = array.getValue(i);
            MetaValue restored = this.processMetaValue(persisted, (MetaValue)value.getValue(i));
            if (restored == null) continue;
            arrayList.add(restored);
        }
        return new ArrayValueSupport(value.getMetaType(), (Object)arrayList.toArray(new MetaValue[arrayList.size()]));
    }

    protected SimpleValue processSimpleValue(PersistedSimpleValue valueElement, SimpleValue value) {
        SimpleMetaType metaType = value.getMetaType();
        String elementValue = valueElement.getValue();
        Object converted = null;
        if (elementValue != null) {
            if (metaType.equals((Object)SimpleMetaType.STRING)) {
                converted = elementValue;
            } else if (metaType.equals((Object)SimpleMetaType.NAMEDOBJECT)) {
                converted = new StringName(elementValue);
            } else if (!metaType.equals((Object)SimpleMetaType.VOID)) {
                converted = this.convert2Type(metaType.getTypeName(), elementValue);
            }
        }
        return SimpleValueSupport.wrap(converted);
    }

    protected MetaValue createEmptyMetaValue(MetaType metaType) {
        SimpleValueSupport metaValue = null;
        if (metaType.isSimple()) {
            metaValue = new SimpleValueSupport((SimpleMetaType)metaType, null);
        } else if (metaType.isEnum()) {
            metaValue = new EnumValueSupport((EnumMetaType)metaType, (String)null);
        } else if (metaType.isCollection()) {
            metaValue = new CollectionValueSupport((CollectionMetaType)metaType);
        } else if (!metaType.isGeneric()) {
            if (metaType.isComposite()) {
                metaValue = new CompositeValueSupport((CompositeMetaType)metaType);
            } else if (metaType.isTable()) {
                metaValue = new TableValueSupport((TableMetaType)metaType);
            } else if (metaType.isArray()) {
                metaValue = new ArrayValueSupport((ArrayMetaType)metaType);
            }
        }
        return metaValue;
    }

    public Serializable convert2Type(String className, String value) {
        if (value == null) {
            return null;
        }
        Class<? extends Serializable> clazz = simpleTypes.get(className);
        if (clazz == null) {
            throw new IllegalStateException("Cannot find simple type entry for " + value + " and class " + className);
        }
        try {
            return (Serializable)ValueConvertor.convertValue(clazz, (Object)value);
        }
        catch (Throwable t) {
            log.debug((Object)("could convert " + value + " to " + clazz.getName()));
            return null;
        }
    }

    static {
        simpleTypes.put(BigDecimal.class.getName(), BigDecimal.class);
        simpleTypes.put(BigInteger.class.getName(), BigInteger.class);
        simpleTypes.put(Boolean.class.getName(), Boolean.class);
        simpleTypes.put(Byte.class.getName(), Byte.class);
        simpleTypes.put(Character.class.getName(), Character.class);
        simpleTypes.put(Date.class.getName(), Date.class);
        simpleTypes.put(Double.class.getName(), Double.class);
        simpleTypes.put(Float.class.getName(), Float.class);
        simpleTypes.put(Integer.class.getName(), Integer.class);
        simpleTypes.put(Long.class.getName(), Long.class);
        simpleTypes.put(Short.class.getName(), Short.class);
        simpleTypes.put(String.class.getName(), String.class);
        simpleTypes.put(Name.class.getName(), Name.class);
    }
}

