/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profileservice.persistence.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * A Map helper class.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public abstract class AbstractMapSupport<T extends PersistedElement> extends AbstractElement
{
   /** The map. */
   private Map<String, T> map = new HashMap<String, T>();

   public AbstractMapSupport()
   {
      //
   }
   
   public AbstractMapSupport(String name)
   {
      super(name, null);
   }
   
   public AbstractMapSupport(String name, String className)
   {
      super(name, className);
   }
   
   public Set<String> keySet()
   {
      return map.keySet();
   }

   public T get(String name)
   {
      return map.get(name);
   }
   
   public void put(String name, T element)
   {
      if(name == null)
         throw new IllegalArgumentException("Null name.");

      this.map.put(name, element);
   }
   
   public Collection<T> values()
   {
      return this.map.values();
   }
   
   public void createMap(Collection<T> collection)
   {
      if(collection == null)
         throw new IllegalArgumentException("null children.");
      
      for(T element : collection)
      {
         if(element.getName() == null)
            throw new IllegalStateException("name required for element: "+ element);
         
         this.map.put(element.getName(), element);
      }
   }

}
