/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.metadata.spi.MetaData;
import org.jboss.system.server.profileservice.persistence.ManagedObjectUpdateHandler;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;

public class ProfileServicePersistenceDeployer
extends AbstractRealDeployer {
    public static final String PERSISTED_ATTACHMENT_PREFIX = "PERISTED";
    private ManagedObjectUpdateHandler handler = new ManagedObjectUpdateHandler();
    private final ManagedObjectFactory factory = ManagedObjectFactoryBuilder.create();
    private static final Logger log = Logger.getLogger(ProfileServicePersistenceDeployer.class);

    public ProfileServicePersistenceDeployer() {
        this.setAllInputs(true);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        MetaData metaData = unit.getMetaData();
        Set attachments = unit.getTransientManagedObjects().getAttachments().keySet();
        for (String attachment : attachments) {
            PersistedManagedObject persistedManagedObject = (PersistedManagedObject)unit.getAttachment(PERSISTED_ATTACHMENT_PREFIX + attachment);
            if (persistedManagedObject == null) continue;
            Object instance = unit.getTransientManagedObjects().getAttachment(attachment);
            ManagedObject mo = this.factory.initManagedObject(instance, metaData);
            Object o = this.handler.processManagedObject(persistedManagedObject, mo);
            log.debug((Object)("updated attachment with persisted information: " + o));
            unit.addAttachment(attachment, o);
        }
    }
}

