/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profile.repository.metadata;

import java.util.List;

import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.jboss.profileservice.spi.metadata.ProfileDeploymentMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * A filtered profile source meta data. 
 * This is a workaround that we can a filtered deploymentRepository 
 * on this metadata only, based on the deployments list.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
@JBossXmlSchema(namespace="urn:jboss:profileservice:source:filtered:1.0", elementFormDefault=XmlNsForm.QUALIFIED)
@XmlRootElement(name = "profile-source")
public class FilteredProfileSourceMetaData extends AbstractProfileSourceMetaData
{
   
   /** The deployments */
   List<ProfileDeploymentMetaData> deployments;

   @XmlTransient
   public List<ProfileDeploymentMetaData> getDeployments()
   {
      return deployments;
   }
   
   public void setDeployments(List<ProfileDeploymentMetaData> deployments)
   {
      this.deployments = deployments;
   }
   
}

