/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profileservice.persistence;

import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.metadata.spi.MetaData;

/**
 * ManagedObject creator plugin.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class MOCreatorPlugin
{

   /** The classloader. */
   private ClassLoader loader;
   
   /** The managed object factory. */
   private ManagedObjectFactory managedObjectFactory;
   
   public MOCreatorPlugin()
   {
      this.managedObjectFactory = ManagedObjectFactoryBuilder.create();
   }
   
   public MOCreatorPlugin(ManagedObjectFactory managedObjectFactory)
   {
      this.managedObjectFactory = managedObjectFactory;
   }
   
   public ManagedObjectFactory getMOF()
   {
      return managedObjectFactory;
   }
   
   public void setMOF(ManagedObjectFactory managedObjectFactory)
   {
      this.managedObjectFactory = managedObjectFactory;
   }
   
   public ClassLoader getClassLoader()
   {
      if(this.loader == null)
         return Thread.currentThread().getContextClassLoader();
      return this.loader;
   }
   
   public void setClassLoader(ClassLoader classLoader)
   {
      this.loader = classLoader;
   }
   
   public ManagedObject createManagedObject(String clazz, MetaData metaData) throws Exception
   {
      return getMOF().createManagedObject(createManagedObjectClass(clazz), metaData);
   }
   
   public ManagedObject initManagedObject(Object o, MetaData metaData) throws Exception
   {
      return getMOF().initManagedObject(o, metaData);
   }
   
   protected Class<?> createManagedObjectClass(String clazz) throws Exception
   {
      return getClassLoader().loadClass(clazz);
   }
   
}

