/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.repository;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.AbstractVFSProfileSource;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractImmutableProfile
extends AbstractVFSProfileSource
implements Profile {
    private ProfileKey key;
    private List<ProfileKey> subProfiles;

    public AbstractImmutableProfile(ProfileKey key, URI[] uris) {
        this(key, uris, null);
    }

    public AbstractImmutableProfile(ProfileKey key, URI[] uris, List<ProfileKey> subprofiles) {
        super(uris);
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        this.key = key;
        this.subProfiles = subprofiles;
    }

    public void create() throws Exception {
        for (URI uri : this.getRepositoryURIs()) {
            VirtualFile root = this.getCachedVirtualFile(uri);
            this.loadApplications(root);
        }
        this.updateLastModfied();
    }

    public ProfileKey getKey() {
        return this.key;
    }

    public Collection<ProfileKey> getSubProfiles() {
        return this.subProfiles;
    }

    public void setSubProfiles(List<ProfileKey> subProfiles) {
        this.subProfiles = subProfiles;
    }

    @Override
    public ProfileDeployment getDeployment(String vfsPath) throws NoSuchDeploymentException {
        if (vfsPath == null) {
            throw new IllegalArgumentException("Null name");
        }
        ProfileDeployment ctx = super.getDeployment(vfsPath);
        if (ctx == null) {
            List<String> names = this.findDeploymentContent(vfsPath);
            if (names.size() == 1) {
                ctx = super.getDeployment(names.get(0));
            } else if (names.size() > 1) {
                throw new NoSuchDeploymentException("Multiple deployments found for: " + vfsPath + ", available: " + names);
            }
        }
        if (ctx == null) {
            this.log.debug((Object)("Failed to find application for: " + vfsPath + ", available: " + this.getDeploymentNames()));
            throw new NoSuchDeploymentException("Failed to find deployment in file: " + vfsPath);
        }
        return ctx;
    }

    public boolean hasDeployment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        try {
            return super.getDeployment(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isMutable() {
        return false;
    }
}

