/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProfile
implements MutableProfile {
    private final ProfileKey key;
    private final DeploymentRepository repository;
    List<ProfileKey> subProfiles;
    private volatile boolean hotdeployEnabled = false;

    public AbstractProfile(DeploymentRepository repository, ProfileKey key) {
        this(repository, key, null);
    }

    public AbstractProfile(DeploymentRepository repository, ProfileKey key, List<ProfileKey> subProfiles) {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Null deployment repository.");
        }
        this.key = key;
        this.repository = repository;
        this.subProfiles = subProfiles;
    }

    public void addDeployment(ProfileDeployment d) throws Exception {
        if (d == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        this.repository.addDeployment(d.getName(), d);
    }

    public void enableModifiedDeploymentChecks(boolean flag) {
        this.hotdeployEnabled = flag;
    }

    public ProfileDeployment getDeployment(String name) throws NoSuchDeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        return this.repository.getDeployment(name);
    }

    public Set<String> getDeploymentNames() {
        return this.repository.getDeploymentNames();
    }

    public Collection<ProfileDeployment> getDeployments() {
        return this.repository.getDeployments();
    }

    public ProfileKey getKey() {
        return this.key;
    }

    public Collection<ProfileKey> getSubProfiles() {
        return this.subProfiles;
    }

    public void setSubProfiles(List<ProfileKey> subProfiles) {
        this.subProfiles = subProfiles;
    }

    public long getLastModified() {
        return this.repository.getLastModified();
    }

    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        if (!this.hotdeployEnabled) {
            return Collections.emptySet();
        }
        return this.repository.getModifiedDeployments();
    }

    public boolean hasDeployment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        try {
            return this.repository.getDeployment(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ProfileDeployment removeDeployment(String name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        return this.repository.removeDeployment(name);
    }

    public void create() throws Exception {
        if (this.repository == null) {
            throw new IllegalStateException("Null deployment repository.");
        }
        this.repository.load();
    }

    public void destroy() {
        this.repository.unload();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{key = ").append(this.getKey());
        this.toString(builder);
        builder.append("}");
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
    }

    public boolean isMutable() {
        return true;
    }
}

