/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.lang.reflect.Proxy;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;

public class AttachmentPropertyPopulator {
    private ManagedObjectFactory managedObjectFactory;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final Logger log = Logger.getLogger(AttachmentPropertyPopulator.class);

    public AttachmentPropertyPopulator() {
        this.managedObjectFactory = ManagedObjectFactory.getInstance();
    }

    public AttachmentPropertyPopulator(ManagedObjectFactory managedObjectFactory) {
        this.managedObjectFactory = managedObjectFactory;
    }

    public void processManagedProperty(String name, ManagedProperty property, Object attachment) throws Throwable {
        Object unwrapped;
        boolean trace = log.isTraceEnabled();
        PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (propertyInfo == null || !propertyInfo.isWritable()) {
            if (trace) {
                log.debug((Object)("Skipping not writable property " + propertyInfo));
            }
            return;
        }
        MetaType metaType = property.getMetaType();
        MetaValue value = property.getValue();
        if (metaType.isComposite() && !metaType.getTypeName().equals(ObjectName.class.getName()) && Proxy.isProxyClass((unwrapped = this.metaValueFactory.unwrap(value, propertyInfo.getType())).getClass())) {
            return;
        }
        InstanceClassFactory icf = this.managedObjectFactory.getInstanceClassFactory(attachment.getClass(), null);
        BeanInfo beanInfo = propertyInfo.getBeanInfo();
        icf.setValue(beanInfo, property, attachment, value);
    }
}

