/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.system.server.profileservice.persistence.ManagedObjectOverride;
import org.jboss.system.server.profileservice.persistence.xml.ModificationInfo;
import org.jboss.system.server.profileservice.persistence.xml.PersistedGenericValue;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;

public class ManagedGenericOverrideHandler
extends ManagedObjectOverride {
    private Stack<MergingProperties> properties = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processProperty(ManagedProperty property, PersistedProperty propertyElement, Object attachment, boolean trace) throws Throwable {
        if (property == null) {
            throw new IllegalStateException("Null property");
        }
        PropertyInfo info = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (!info.isReadable()) {
            log.trace((Object)("Skipping not readable property " + info));
            return;
        }
        MergingProperties item = new MergingProperties(attachment, info, propertyElement);
        this.properties.push(item);
        try {
            super.processProperty(property, propertyElement, attachment, trace);
        }
        finally {
            this.properties.pop();
        }
    }

    protected void setValue(ManagedProperty property, MetaValue value, Object attachment) throws Throwable {
        if (value == null) {
            return;
        }
        if (value.getMetaType().isGeneric() && value.getMetaType().equals(GENERIC_PERSISTED_VALUE_TYPE)) {
            PersistedGenericValue moElement = (PersistedGenericValue)((GenericValue)value).getValue();
            if (moElement.getManagedObject() == null) {
                return;
            }
            ManagedObject mo = this.createManagedObject(moElement.getManagedObject());
            value = new GenericValueSupport(AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE, (Serializable)mo);
        }
        super.setValue(property, value, attachment);
    }

    protected CollectionValue mergeCollection(CollectionValue original, CollectionValue override, boolean trace) throws Throwable {
        CollectionMetaType metaType = original.getMetaType();
        if (metaType.getElementType().isGeneric()) {
            Object attachment;
            MergingProperties item = this.properties.peek();
            PropertyInfo propertyInfo = item.getPropertyInfo();
            Collection c = (Collection)propertyInfo.get(attachment = item.getAttachment());
            if (c.size() < override.getSize()) {
                throw new IllegalStateException("c.size() < override.getSize()");
            }
            Iterator rawIterator = c.iterator();
            Iterator originalIterator = original.iterator();
            Iterator overrideIterator = override.iterator();
            while (rawIterator.hasNext()) {
                rawIterator.next();
                GenericValue originalGeneric = (GenericValue)originalIterator.next();
                GenericValue overrideGeneric = (GenericValue)overrideIterator.next();
                PersistedGenericValue overrideGenericValue = (PersistedGenericValue)overrideGeneric.getValue();
                if (originalGeneric.getValue() == null) continue;
                ModificationInfo modificationInfo = overrideGenericValue.getModificationInfo();
                if (modificationInfo != null && modificationInfo == ModificationInfo.REMOVED) {
                    rawIterator.remove();
                    continue;
                }
                this.processGenericValue(originalGeneric, overrideGenericValue, trace);
            }
            return null;
        }
        return super.mergeCollection(original, override, trace);
    }

    public static class MergingProperties {
        private Object attachment;
        private PropertyInfo propertyInfo;
        private PersistedProperty propertyElement;

        public MergingProperties(Object attachment, PropertyInfo info, PersistedProperty propertyElement) {
            this.attachment = attachment;
            this.propertyInfo = info;
            this.propertyElement = propertyElement;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public PropertyInfo getPropertyInfo() {
            return this.propertyInfo;
        }

        public PersistedProperty getPropertyElement() {
            return this.propertyElement;
        }
    }
}

