/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileKeyMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.SubProfileMetaData;
import org.jboss.system.server.profileservice.repository.AbstractProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBootstrapProfileFactory {
    private Map<ProfileKey, ProfileMetaData> profileMap = new HashMap<ProfileKey, ProfileMetaData>();
    private Map<ProfileKey, List<ProfileMetaData>> profilesMetaData = new HashMap<ProfileKey, List<ProfileMetaData>>();
    private AbstractProfileFactory profileFactory;
    protected final Logger log = Logger.getLogger(this.getClass());

    public AbstractProfileFactory getProfileFactory() {
        return this.profileFactory;
    }

    public void setProfileFactory(AbstractProfileFactory profileFactory) {
        this.profileFactory = profileFactory;
    }

    protected abstract void createProfileMetaData(ProfileKey var1, URL var2) throws Exception;

    public Collection<Profile> createProfiles(ProfileKey rootKey, URL url) throws Exception {
        if (rootKey == null) {
            throw new IllegalArgumentException("Null profile key");
        }
        this.createProfileMetaData(rootKey, url);
        HashMap<ProfileKey, Profile> profiles = new HashMap<ProfileKey, Profile>();
        this.createProfiles(profiles, rootKey);
        return profiles.values();
    }

    public void createProfiles(Map<ProfileKey, Profile> profiles, ProfileKey key) throws Exception {
        ProfileMetaData profileMetaData = this.profileMap.get(key);
        if (profileMetaData == null) {
            throw new IllegalStateException("Could not find metaData for key: " + key);
        }
        ArrayList<ProfileKey> subProfiles = new ArrayList<ProfileKey>();
        this.createProfile(profiles, subProfiles, key, profileMetaData);
    }

    public void createProfile(Map<ProfileKey, Profile> profiles, List<ProfileKey> subProfiles, ProfileKey key, ProfileMetaData profileMetaData) throws Exception {
        if (profiles.containsKey(key)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating profile for key: " + key));
        }
        this.processSubProfiles(profiles, subProfiles, profileMetaData.getSubprofiles());
        Profile profile = this.profileFactory.createProfile(key, profileMetaData, subProfiles);
        profiles.put(key, profile);
        if (!subProfiles.contains(key)) {
            subProfiles.add(key);
        }
    }

    private void processSubProfiles(Map<ProfileKey, Profile> profiles, List<ProfileKey> subProfileKeys, List<SubProfileMetaData> subProfilesMetaData) throws Exception {
        if (subProfilesMetaData == null || subProfilesMetaData.isEmpty()) {
            return;
        }
        for (SubProfileMetaData subProfile : subProfilesMetaData) {
            ProfileKey subProfileKey = AbstractBootstrapProfileFactory.createProfileKey((ProfileKeyMetaData)subProfile);
            if (this.profileMap.containsKey(subProfileKey)) {
                this.createProfile(profiles, subProfileKeys, subProfileKey, this.profileMap.get(subProfileKey));
                continue;
            }
            if (this.profilesMetaData.containsKey(subProfileKey)) {
                List<ProfileMetaData> subProfileAliases = this.profilesMetaData.get(subProfileKey);
                this.processSubProfileAlias(profiles, subProfileKeys, subProfileAliases);
                continue;
            }
            throw new IllegalStateException("Could not resolve profile meta data for key: " + subProfileKey);
        }
    }

    private void processSubProfileAlias(Map<ProfileKey, Profile> profiles, List<ProfileKey> subProfileKeys, List<ProfileMetaData> subprofileAliases) throws Exception {
        if (subprofileAliases == null || subprofileAliases.isEmpty()) {
            return;
        }
        for (ProfileMetaData metaData : subprofileAliases) {
            ProfileKey key = AbstractBootstrapProfileFactory.createProfileKey((ProfileKeyMetaData)metaData);
            this.createProfile(profiles, subProfileKeys, key, metaData);
        }
    }

    protected void addProfile(ProfileKey key, ProfileMetaData metaData) {
        if (this.profileMap.containsKey(key)) {
            throw new IllegalStateException("Duplicate key: " + key);
        }
        if (this.profilesMetaData.containsKey(key)) {
            throw new IllegalStateException("Duplicate key: " + key);
        }
        this.profileMap.put(key, metaData);
    }

    protected void addProfiles(ProfileKey key, List<ProfileMetaData> metaData) {
        if (this.profileMap.containsKey(key)) {
            if ("default".equals(key.getDomain()) && "default".equals(key.getServer()) && "default".equals(key.getName())) {
                return;
            }
            throw new IllegalStateException("Duplicate key: " + key);
        }
        List<ProfileMetaData> profileList = this.profilesMetaData.get(key);
        if (profileList == null) {
            profileList = new ArrayList<ProfileMetaData>();
            this.profilesMetaData.put(key, profileList);
        }
        if (metaData != null && !metaData.isEmpty()) {
            profileList.addAll(metaData);
        }
    }

    public static ProfileKey createProfileKey(ProfileKeyMetaData md) {
        return new ProfileKey(md.getDomain(), md.getServer(), md.getName());
    }
}

