/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.ImmutableProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.ImmutableDeploymentRepository;
import org.jboss.system.server.profileservice.repository.MutableDeploymentRepository;
import org.jboss.virtual.VirtualFileFilter;

public class DefaultDeploymentRepositoryFactory
implements DeploymentRepositoryFactory {
    public static final String MUTABLE_TYPE = HotDeploymentProfileSourceMetaData.class.getName();
    public static final String IMMUTABLE_TYPE = ImmutableProfileSourceMetaData.class.getName();
    public static final Collection<String> types = Arrays.asList(MUTABLE_TYPE, IMMUTABLE_TYPE);
    private VirtualFileFilter deploymentFilter;
    private StructureModificationChecker checker;

    public String[] getTypes() {
        return types.toArray(new String[types.size()]);
    }

    public VirtualFileFilter getDeploymentFilter() {
        return this.deploymentFilter;
    }

    public void setDeploymentFilter(VirtualFileFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    public StructureModificationChecker getChecker() {
        return this.checker;
    }

    public void setChecker(StructureModificationChecker checker) {
        this.checker = checker;
    }

    public DeploymentRepository createDeploymentRepository(ProfileKey key, ProfileSourceMetaData metaData) throws Exception {
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        String repositoryType = metaData.getType();
        if (repositoryType == null) {
            throw new IllegalArgumentException("Null repository type.");
        }
        if (!types.contains(repositoryType)) {
            throw new IllegalArgumentException("Cannot handle type: " + repositoryType);
        }
        boolean mutable = false;
        if (repositoryType.equals(MUTABLE_TYPE)) {
            mutable = true;
        }
        return this.createDeploymentRepository(mutable, key, this.createUris(metaData));
    }

    protected DeploymentRepository createDeploymentRepository(boolean mutable, ProfileKey key, URI[] uris) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (uris == null) {
            throw new IllegalArgumentException("Null uris");
        }
        if (mutable) {
            MutableDeploymentRepository repository = new MutableDeploymentRepository(key, uris);
            repository.setDeploymentFilter(this.deploymentFilter);
            repository.setChecker(this.checker);
            return repository;
        }
        ImmutableDeploymentRepository repository = new ImmutableDeploymentRepository(key, uris);
        repository.setDeploymentFilter(this.deploymentFilter);
        return repository;
    }

    protected URI[] createUris(ProfileSourceMetaData metaData) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String source : metaData.getSources()) {
            URI uri = new URI(source);
            uris.add(uri);
        }
        return uris.toArray(new URI[uris.size()]);
    }
}

