/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.Collection;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.repository.AbstractProfileAction;
import org.jboss.system.server.profileservice.repository.MainDeployerAdapter;

public class ProfileDeployAction
extends AbstractProfileAction {
    private MainDeployerAdapter deployer;

    public ProfileDeployAction(MainDeployerAdapter deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployer = deployer;
    }

    public void install(Profile profile) throws Exception {
        Collection deployments = profile.getDeployments();
        if (deployments != null && !deployments.isEmpty()) {
            for (ProfileDeployment deployment : profile.getDeployments()) {
                this.deployer.addDeployment(deployment);
            }
            this.deployer.process();
        }
    }

    public void uninstall(Profile profile) throws Exception {
        Collection deployments = profile.getDeployments();
        if (deployments != null && !deployments.isEmpty()) {
            for (ProfileDeployment deployment : profile.getDeployments()) {
                try {
                    this.deployer.removeDeployment(deployment);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("failed to  undeploy: " + t));
                }
            }
            try {
                this.deployer.process();
            }
            catch (Throwable t) {
                this.log.warn((Object)"Error on releasing profile: ", t);
            }
        }
    }
}

