/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profileservice.hotdeploy.Scanner;
import org.jboss.system.server.profileservice.repository.MutableDeploymentRepository;
import org.jboss.system.tools.DeploymentRepositoryAdapter;
import org.jboss.virtual.VirtualFile;

public class ProfileServiceDeploymentRepositoryAdapter
implements DeploymentRepositoryAdapter {
    private static final Logger log = Logger.getLogger(ProfileServiceDeploymentRepositoryAdapter.class);
    private static final ProfileKey profileName = new ProfileKey("deployment-scanner-profile");
    private Scanner scanner;
    private ProfileService ps;
    private DeploymentScannerProfile profile;

    public ProfileServiceDeploymentRepositoryAdapter(Scanner scanner, ProfileService ps) {
        if (scanner == null) {
            throw new IllegalArgumentException("Null scanner");
        }
        if (ps == null) {
            throw new IllegalArgumentException("Null profile service");
        }
        this.scanner = scanner;
        this.ps = ps;
    }

    public void create() throws Exception {
        this.profile = new DeploymentScannerProfile();
        this.registerProfile();
    }

    public void destroy() {
        this.stopProfile();
    }

    protected void registerProfile() throws Exception {
        if (this.ps == null) {
            throw new IllegalStateException("Null profile service.");
        }
        this.ps.registerProfile((Profile)this.profile);
        log.debug((Object)("Activating deployment scanner profile " + profileName));
        this.ps.activateProfile(profileName);
    }

    public void resume() {
        this.scanner.resume();
    }

    public void suspend() {
        this.scanner.suspend();
    }

    public void stopProfile() {
        try {
            log.debug((Object)("Deactivating deployment scanner profile: " + profileName));
            this.ps.deactivateProfile(profileName);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to deactivate deployment scanner profile: ", (Throwable)e);
        }
        try {
            log.debug((Object)("Unregistering transient profile: " + profileName));
            this.ps.unregisterProfile(profileName);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to unregister deployment scanner profile: ", (Throwable)e);
        }
    }

    public void addURL(URL url) throws URISyntaxException {
        this.profile.getURIs().add(url.toURI());
    }

    public void removeURL(URL url) throws URISyntaxException {
        this.profile.getURIs().remove(url.toURI());
    }

    public boolean hasURL(URL url) throws URISyntaxException {
        URI uri = url.toURI();
        return this.profile.getURIs().contains(uri);
    }

    public URL[] listDeployedURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        Collection activeProfiles = this.ps.getActiveProfileKeys();
        if (activeProfiles != null && !activeProfiles.isEmpty()) {
            for (ProfileKey key : activeProfiles) {
                Profile profile;
                try {
                    profile = this.ps.getActiveProfile(key);
                }
                catch (NoSuchProfileException ignore) {
                    continue;
                }
                Collection deployments = profile.getDeployments();
                if (deployments == null || deployments.isEmpty()) continue;
                for (ProfileDeployment pd : deployments) {
                    VirtualFile root = pd.getRoot();
                    if (root == null) continue;
                    try {
                        urls.add(root.toURL());
                    }
                    catch (Exception e) {
                        log.warn((Object)("Exception while reading root's URL: " + root));
                    }
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeploymentScannerProfile
    extends MutableDeploymentRepository
    implements MutableProfile {
        private volatile boolean enableHotDeployment;

        public DeploymentScannerProfile() {
            super(profileName, new URI[0]);
        }

        Collection<URI> getURIs() {
            return this.uris;
        }

        public void addDeployment(ProfileDeployment deployment) throws Exception {
            super.addDeployment(deployment.getName(), deployment);
        }

        public void enableModifiedDeploymentChecks(boolean flag) {
            this.enableHotDeployment = flag;
        }

        @Override
        public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
            if (!this.enableHotDeployment) {
                return Collections.emptySet();
            }
            return super.getModifiedDeployments();
        }

        public ProfileKey getKey() {
            return profileName;
        }

        public Collection<ProfileKey> getSubProfiles() {
            return Collections.emptySet();
        }

        public boolean hasDeployment(String name) {
            return false;
        }

        public boolean isMutable() {
            return true;
        }
    }
}

