/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profile.repository.metadata;

import java.util.List;

import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;

import org.jboss.profileservice.spi.metadata.SubProfileMetaData;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * The meta data defining a filtered profile. This is the
 * standard type of a profile.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 86174 $
 */
@JBossXmlSchema(namespace="urn:jboss:profileservice:profile:filtered:1.0", elementFormDefault=XmlNsForm.QUALIFIED)
@XmlRootElement(name = "profile")
public class FilteredProfileMetaData extends BasicProfileMetaData
{

   public FilteredProfileMetaData()
   {
      super();
   }
   
   public FilteredProfileMetaData(String domain, String server, String name)
   {
      super(domain, server, name, null);
   }
   
   public FilteredProfileMetaData(String domain, String server, String name, List<SubProfileMetaData> subProfiles)
   {
      super(domain, server, name, subProfiles);
   }
   
}

